#pragma once

#include "mbed.h"

class Ir {
public:
    Ir();
    void reset() volatile;
    float right() volatile;
    float left() volatile;
    
    float get_ir_error();
    float flash_ir(DigitalOut ir, AnalogIn rec) volatile;
    
    bool wallRight(DigitalOut ir_R, AnalogIn rec_R) volatile;
    bool wallLeft(DigitalOut ir_L, AnalogIn rec_L) volatile;
    bool wallFront(DigitalOut ir_FR, DigitalOut ir_FL, AnalogIn rec_FR, AnalogIn rec_FL) volatile;
    
    void update() volatile;
    
    void printValues() volatile;
    
private:
//    float m_irL;
//    float m_irR;
    float m_recL;
    float m_recR;
    float m_recFL;
    float m_recFR;
};