#include "string.h"
#include "mbed.h"
#include "SDFileSystem.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
AnalogIn ain(p20);
DigitalOut sensor(p15);
Serial pc(p28, p27);
SDFileSystem sd(p5, p6, p7, p8, "sd"); 
#define USR_POWERDOWN    (0x104)

int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}
Ticker sense; // Ticker to Interrupt the sleeping mode
Timer t;

void sd_write_read() {
    char data[100];
    int time_stamp;
    time_stamp=t.read();
    sensor=1;   /* Power up Sensor only when necessary */
    pc.printf("\n Writing into SD card... \n");
    pc.printf("\n Writing Sensor Data... \n");
    mkdir("/sd/mydir", 0777);
    /* Following code does a conditional check on analog in to determine the distance from IR Sensor */
    if (ain < 0.3) {
        strcpy(data,"Its approximately 30 cm away");
    } else if (ain > 0.3&&ain < 0.5) {
        strcpy(data,"Its approximately 20 cm away");
    } else if (ain>0.5 && ain < 0.6) {
        strcpy(data,"Its approximately 15 cm away");
    } else {
        strcpy(data,"Its approximately 10 cm away");
    }

    /* Open the File for writing into the SD Card */
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    if (fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "%d : %s \n",time_stamp,data);  /* Record Sensor data along with time stamp */
    fclose(fp);
    sensor=0;   /* Power down Sensor after data is logged */
}

int main() {
    int result; 
    PHY_PowerDown();                    /* PHY Powerdown */
    result = semihost_powerdown();      /* Semihost Powerdown */
    sense.attach(&sd_write_read, 5);    /* Excecute sd_write_read function every 5s */
    t.start();                          /* Start of timer to record Time Stamp */
    while (1) {
        Sleep();                        /* Sleep mode to save power */
    }
}


