#include "keyname.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

char keyname(char scancode){
    switch(scancode){
        case 0x16:
            return '1';
        case 0x1E:
            return '2';
        case 0x26:
            return '3';
        case 0x25:
            return '4';
        case 0x2E:
            return '5';
        case 0x36:
            return '6';
        case 0x3D:
            return '7';
        case 0x3E:
            return '8';
        case 0x46:
            return '9';
        case 0x45:
            return '0';
        case 0x15:
            return 'Q';
        case 0x1D:
            return 'W';
        case 0x24:
            return 'E';
        case 0x2D:
            return 'R';
        case 0x2C:
            return 'T';
        case 0x35:
            return 'Y';
        case 0x3C:
            return 'U';
        case 0x43:
            return 'I';
        case 0x44:
            return 'O';
        case 0x4D:
            return 'P';
        case 0x1C:
            return 'A';
        case 0x1B:
            return 'S';
        case 0x23:
            return 'D';
        case 0x2B:
            return 'F';
        case 0x34:
            return 'G';
        case 0x33:
            return 'H';
        case 0x3B:
            return 'J';
        case 0x42:
            return 'K';
        case 0x4B:
            return 'L';
        case 0x1A:
            return 'Z';
        case 0x22:
            return 'X';
        case 0x21:
            return 'C';
        case 0x2A:
            return 'V';
        case 0x32:
            return 'B';
        case 0x31:
            return 'N';
        case 0x3A:
            return 'M';
        case 0x4e:
            return '-';
        case 0x49:
            return '.';
        case 0x29:
            return ' ';
        default:
            return '?';
    }
}

int curstr(char* str,int numchar,char c){
    if((c != 0x66)&&(c != 0x5A)){
        if(numchar < 32){ 
            char k = keyname(c);
            if(k!= '?'){
                str[numchar] = k;
                numchar++;
            }
        }
        else {
            myled1 = !myled1;
            myled2 = !myled2;
            myled3 = !myled3;
            myled4 = !myled4;
            wait(0.2);
            myled1 = !myled1;
            myled2 = !myled2;
            myled3 = !myled3;
            myled4 = !myled4;    
            wait(0.2);
        }
    }
    else if(c == 0x66 && numchar > 0){
        numchar = numchar - 1;
        str[numchar] = ' ';
    }
    return numchar;
}

int keyhit(char* str,int numchar,PS2Keyboard::keyboard_event_t evt_kb){
    
    return numchar;
}