/**************************************************************/
// Name: Commande.h
// 
// Description: defines a command object for checking and  
//  executing commands
//
/**************************************************************/

#include "Command.h"
#include "Interface.h"
#include "PS2Keyboard.h"
#include <string.h>
#include "keyname.h"
#include "TextLCD.h"
#include <stdlib.h>

Interface interface[32];

/*Command::Command(char* cmdname){
    strcpy(name, cmdname);
    parameter_count = 0;
}

int Command::addParameter(char* param){
    
    return parameter_count++;
}*/

PS2Keyboard ps2kb(p12, p11); // CLK, DAT
//Serial pc(USBTX, USBRX);
TextLCD pc(p15, p16, p17, p18, p19, p20);
//char input[32];

DigitalOut testled(LED2);

void execute(char* input){
    char* cmdname = strtok(input," -");
    char* param;
    if(strcmp(cmdname, "DIN") == 0){
        param = strtok(NULL," -");
        // create operation
        if(strcmp(param, "C") == 0){
            param = strtok (NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                if(pin_num >= 5 && pin_num <= 32){
                    pc.printf("\n\nCreating D_IN...");
                    wait(2);
                    interface[pin_num-5].p_object = malloc(sizeof(DigitalIn));
                    memmove(interface[pin_num-5].p_object, &DigitalIn(getPin(pin_num)), sizeof(DigitalIn));
                }
            }
            else {  //pins not given
            }
        }
        // read operation
        else if(strcmp(param, "R") == 0){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                if(pin_num >= 5 && pin_num <= 32){
                    pc.printf("\n\nReading...");
                    int val = ((DigitalIn)(*(DigitalIn*)interface[pin_num-5].p_object)).read();
                    pc.printf("\nI am: %d", val);
                    wait(2);
                }
            }
        }
    }
    else if((strcmp(cmdname, "DOUT")) == 0){
        param = strtok(NULL," -");
        // create operation
        if(strcmp(param, "C") == 0){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param + 1);
                if(pin_num >= 5 && pin_num <= 32){
                    pc.printf("\n\nCreating D_Out..");
                    wait(1);
                    //DigitalOut tmp(getPin(pin_num));
                    //interface[pin_num-5].p_object = &tmp;
                    //interface[pin_num-5].dout = &DigitalOut(getPin(pin_num));
                    interface[pin_num-5].p_object = malloc(sizeof(DigitalOut));
                    //(DigitalOut)interface[pin_num-5].p_object = DigitalOut(getPin(pin_num));
                    memmove(interface[pin_num-5].p_object, &DigitalOut(getPin(pin_num)), sizeof(DigitalOut));
                    //pc.printf("\n\nwriting to %X", interface[pin_num-5].p_object);
                    //wait(2);
                    
                    /*DigitalOut t = *((DigitalOut*)(interface[pin_num-5].p_object));
                    
                    wait(4);*/
                    //interface[pin_num-5].dout = &tmp;
                    
                }
            }
            else {  //pins not given
            }
        }
        // write operation
        else if(strcmp(param, "W") == 0){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param + 1);
                if(pin_num >= 5 && pin_num <= 32){
                    param = strtok(NULL," -");
                    int a = str2int(param);
                    //interface[pin_num-5].dout = a;
                    //(DigitalOut)(*((DigitalOut*)(interface[pin_num-5].dout))).write(a);
                    //DigitalOut t = *((DigitalOut*)(interface[pin_num-5].p_object));
                    //memcpy(, sizeof(DigitalOut));
                    //pc.printf("\n\na:%X", interface[pin_num-5].p_object);
                    //pc.printf("\nb:%X", &t);
                    //wait(2);
                    pc.printf("\n\nWriting...");
                    wait(2);
                    ((DigitalOut)(*(DigitalOut*)interface[pin_num-5].p_object)).write(a);
                    //t = a;
                    //(DigitalOut)(*(interface[pin_num-5].dout)).write(a);
                }
            }
            else{ //Bad pin parameter
            }
        }
        
        else if(strcmp(param, "R") == 0){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param + 1);
                if(pin_num >= 5 && pin_num <= 32){
                    pc.printf("\n\nWriting...");
                    wait(2);
                    int a = ((DigitalOut)(*(DigitalOut*)interface[pin_num-5].p_object)).read();
                    pc.printf("\n\n Value = %d", a);
                    wait(2);
                }
            }
            else{ //Bad pin parameter
            }
        }
    }
    else if(!strcmp(cmdname, "I2C")){
        char* param = strtok(NULL," -");
        // create operation
        if(!strcmp(param, "C")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                pc.printf("\n\nCreating I2C...");
                wait(2);
                int pin_num = str2int(param+1);
                interface[pin_num-5].p_object = malloc(sizeof(I2C));
                if(pin_num == 9 || pin_num == 10){
                    memmove(interface[pin_num-5].p_object, &I2C(p9, p10), sizeof(I2C));
                }
                else if(pin_num == 28 || pin_num == 27){
                    memmove(interface[pin_num-5].p_object, &I2C(p28, p27), sizeof(I2C));
                }
            }
            else {  //pins not given
            }
        }
        // write operation
        else if(!strcmp(param, "W")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
            
                pc.printf("\n\nWriting to I2C...");
                wait(2);
                int pin_num = str2int(param+1);
                //I2C tmp = *((I2C*)(interface[pin_num-5].p_object));
                
                int addr, strlen;
                
                param = strtok(NULL," -");
                addr = hexstr2int(param);
                param = strtok(NULL," -");
                strlen = str2int(param);
                char cmd[strlen];
                for(int i = 0; i < strlen; i++){
                    param = strtok(NULL," -");
                    cmd[i] = str2int(&param[i]);
                }
                
                
                ((I2C)(*(I2C*)interface[pin_num-5].p_object)).write(addr, cmd, strlen);
            }
        }
        //read
        else if(!strcmp(param, "R")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                pc.printf("\n\nReading from I2C...");
                wait(2);
            
                int pin_num = str2int(param+1);
                int addr, strlen;
                
                param = strtok(NULL," -");
                addr = str2int(param);
                param = strtok(NULL," -");
                strlen = str2int(param);
                char cmd[strlen];
                
                ((I2C)(*(I2C*)interface[pin_num-5].p_object)).read(addr, cmd, strlen);
                // print the ranging data to the screen
                int e = 0;
                for(int i = 1; i < strlen; i++){
                    e =  ((e << 8) + cmd[i]);
                }
                float echo = (float)e* 0.01;
                pc.printf("Value = %.4f\n", echo);
                wait(2);
                // print the ranging data to the screen
                //float echo = 0.01 * ((cmd[0] << 8) + cmd[1]);
                //pc.printf("Range = %.2f\n", echo);
                //wait(2);
            }
        }
    }
    else if(!strcmp(cmdname, "SERIAL")){
    //baud, putc, getc
        char* param = strtok(NULL," -");
        // create operation
        if(!strcmp(param, "C")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                pc.printf("\n\nCreating Serial...");
                wait(2);
                int pin_num = str2int(param+1);
                interface[pin_num-5].p_object = malloc(sizeof(Serial));
                if(pin_num == 9 || pin_num == 10){
                    memmove(interface[pin_num-5].p_object, &Serial(p9, p10), sizeof(Serial));
                }
                else if(pin_num == 13 || pin_num == 14){
                    memmove(interface[pin_num-5].p_object, &Serial(p13, p14), sizeof(Serial));
                }
                else if(pin_num == 28 || pin_num == 27){
                    memmove(interface[pin_num-5].p_object, &Serial(p28, p27), sizeof(Serial));
                }
            }
            else {  //pins not given
            }
        }
        //putc
        else if(!strcmp(param, "P")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                param = strtok(NULL," -");
                int c = str2int(param);
                pc.printf("\n\nPutting a %d", c);
                wait(2);
                ((Serial)(*(Serial*)interface[pin_num-5].p_object)).putc(c);
            }
        }
        //getc
        else if(!strcmp(param, "G")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                int val = ((Serial)(*(Serial*)interface[pin_num-5].p_object)).getc();
                pc.printf("\nValue: %d", val);
                wait(2);
            }
        }
        //baud
        else if(!strcmp(param, "B")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                param = strtok(NULL," -");
                int a = str2int(param);
                pc.printf("\n\nSetting baud to %d", a);
                wait(2);
                ((Serial)(*(Serial*)interface[pin_num-5].p_object)).baud(a);
            }
        }
    }
    
    else if(!strcmp(cmdname, "PWMO")){
        char* param = strtok(NULL," -");
        // create operation
        if(!strcmp(param, "C")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param+1);
                if(pin_num >= 21 && pin_num <= 26){
                    pc.printf("\n\nCreating PWM...");
                    wait(2);
                    interface[pin_num-5].p_object = malloc(sizeof(PwmOut));
                    memmove(interface[pin_num-5].p_object, &PwmOut(getPin(pin_num)), sizeof(PwmOut));
                }
            }
            else {  //pins not given
            }
        }
        //write
        else if(strcmp(param, "W") == 0){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param + 1);
                if(pin_num >= 21 && pin_num <= 26){
                    param = strtok(NULL," -");
                    //float a = str2int(param) / (sizeof(int)*8 - 1);
                    float a = atof(param);
                    pc.printf("\n\nWriting... a %f", a);
                    wait(2);
                    ((PwmOut)(*(PwmOut*)interface[pin_num-5].p_object)).write(a);
                }
            }
            else{ //Bad pin parameter
            }
        }
        
        //read
        else if(!strcmp(param, "R")){
            param = strtok(NULL," -");
            if(param[0] == 'P'){
                int pin_num = str2int(param + 1);
                if(pin_num >= 21 && pin_num <= 26){
                    float a = ((PwmOut)(*(PwmOut*)interface[pin_num-5].p_object)).read();
                    pc.printf("\n\nValue = %f", a);
                    wait(2);
                }
            }
        }
    }
}

void run(){
        /*// Read Input
        pc.printf("> ");
        pc.scanf("%s", input);
        pc.printf("\n\r");
        pc.printf("%s\n\r", input);
        
        // Execute Instruction
        if(1)
            execute(input);*/
            
    PS2Keyboard::keyboard_event_t evt_kb;
    char str[32];
    for(int i = 0; i<32 ; i++) str[i] = ' ';    
    int numchar = 0;
    char *p = str;
    while (1) {
        if (ps2kb.processing(&evt_kb)) {
            for (int i = 0; i < evt_kb.length; i++) {
                if(evt_kb.scancode[i] == 0xf0){
                    i++;
                    char c = evt_kb.scancode[i];
                    if(c == 0x5A){
                        // Gordon can call a function here to use str to do whatever
                        execute(p);
                    
                        for(int i = 0; i<32 ; i++) 
                            p[i] = ' ';
                        numchar = 0;
                    }
                    else numchar = curstr(p,numchar,c);
                }
            }
            for(int i = 0; i<32 ; i++) 
                pc.printf("%c", str[i]);
            pc.printf("\n\n"); 
        }       
        
    }
}

int str2int(char* str) {
    int num = 0, i = 0;
    while(str[i] != NULL){
        num = num * 10 + str[i] - '0';
        i++;
    }
    return num;
}

int hexstr2int(char* str) {
    int num = 0, i = 0;
    while(str[i] != NULL){
        num = num * 16 + str[i] - '0';
        i++;
    }
    return num;
}
