#ifndef _MOVE_H
#define _MOVE_H

#include "mbed.h"
#include "Motor.h"

#define LEFT_C -1
#define RIGHT_C 1
#define FULL_FOWARD 1
#define FULL_REVERSE -1
#define NEUTRAL 0
#define LEFT -1
#define RIGHT 1


#define QTI_THRESH 0.48

#define TICS_PER_MM 40.8407045

typedef enum {Stopped, Moving} MovementState;
extern MovementState move_state;

extern AnalogIn r_encoder;
extern AnalogIn l_encoder;
extern AnalogIn srf;
volatile extern int prev_r_enc;
volatile extern int prev_l_enc;

extern DigitalOut r_charge;
extern DigitalOut l_charge;

extern DigitalOut motor_reset;
extern Motor r_motor;
extern Motor l_motor;

extern Serial pc;

volatile extern int r_tics;
volatile extern int l_tics;

volatile extern int r_goal;
volatile extern int l_goal;

volatile extern float r_C;
volatile extern float l_C;

void moveforward(Motor right,float speed);
void movebackward(Motor right,float speed);
void move(float speed, int tics);
void motors_stop();
void rotate(int);


void QTIsensor_init();
void QTIsensor_charge();
void QTIsensor_discharge();

//Mine
//extern MovementState move_state;

//void accelerate(Motor m, float distance);
//void move(int x, int y);
//void move_line(float distance);
//void rotate_deg(int degrees);
//void rotate_t(float time);
//void move_arc(int radius, int length, int x, int y);

void calibrate(float speed, int rots);
void update_movement(float speed);

#endif
 