#include "mbed.h"
#include "stdio.h"
#include "sms.h"                //custom sms library
#include "SecurityMechanism.h"  //custom security mechanism library
#include "MODSERIAL.h"          //buffer library for serial
#include "GPS.h"                //GPS library
#include "ADXL345.h"            //Sparkfun ADXL345 accelerometer library

// System
DigitalOut pulse(LED1); //heartbeat
Serial pc(USBTX,USBRX); //for debugging

// Peripherals
MODSERIAL gsm(p28,p27);
GPS gps(NC, p10);
ADXL345 accelerometer(p5, p6, p7, p8);

// Power Control
DigitalOut gps_on(p22);
DigitalOut gps_xstandby(p21);
DigitalOut accelerometer_on(p20);
//DigitalIn security_pwrd(p17);
AnalogIn voltage_level(p19);

// Global Vars
int accel_reading[3] = {0, 0, 0};   //x, y, z coordinates of accelerometer
int prev_accel_reading[3] = {0, 0, 0};   //x, y, z coordinates of accelerometer
string phoneNumber = "4047849578";
bool security_enabled = true;
bool movement_detected = false;
bool command_sent = false;
#define ACCEL_THRESH 50

int main() {
    pc.printf("Initializing Program.\r\n");
    //****init GSM    
    GSM_init();
    
    //****init GPS
    pc.printf("Initializing GPS.\r\n");
    GPS_Time t;
    gps.baud(4800);
    
    //****init accelerometer
    accelerometer_on = 1;
    pc.printf("Initializing Accelerometer.\r\n");
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);

    //Measurement mode.
    accelerometer.setPowerControl(0x08);
    
    pc.printf("Initializing Complete.\r\n");
    
    wait(0.4);

    while(1) {
        accelerometer.getOutput(accel_reading);
        //check for movement
        for (int i = 0; i < 3; i++) {
            if (((int16_t)prev_accel_reading[i] != 0) && (int16_t)abs(accel_reading[i] - prev_accel_reading[i]) > ACCEL_THRESH) {
                pc.printf("Movement detected\r\n");
                movement_detected = true;
            }
            prev_accel_reading[i] = accel_reading[i];
        }
        
        //pc.printf("Seurity system = %d\r\n", security_pwrd);
        //security_enabled = security_pwrd;
        
        if (movement_detected) {
            if (security_enabled) {
                //turn off accelerometer
                accelerometer_on = 0;
                pc.printf("Alert\r\n");
                send_location();
                wait(30);
            }
        }
        
        if (command_sent) {
            pc.printf("Ping.\r\n");
            send_location();
            command_sent = false;
            gps_on = 0;
            gps_xstandby = 0;
        }
        
        //heartbeat
        pulse = 1;
        wait(0.2);
        pulse = 0;
        wait(0.2);
    }
}
