#include "sms.h"
#include "SecurityMechanism.h"

#define MESSAGE_BUFFER_SIZE 2*1024

// must define these in main.cpp
extern MODSERIAL gsm;
extern Serial pc;
extern bool command_sent;
char messageBufferIncoming[MESSAGE_BUFFER_SIZE];
//char messageBufferOutgoing[MESSAGE_BUFFER_SIZE];
//bool messageReceived = false;

void GSM_init() {
    pc.printf("Setting up GSM Modem\r\n");
    
    gsm.baud(115200);                         //Set Baud Rate
    
    gsm.puts("AT\r\n");                       //Check Connection
    messageProcess();                         //Process incoming message
    
    // Tune Down Baud
    pc.printf("Slowing Baud Down....");
    gsm.puts("AT+IPR=19200\r\n");            //Select Bearer Servr Type autobaud, No name, Non-transparent
    messageProcess();                         //Process incoming message
    
    gsm.baud(19200);
    gsm.format(8, Serial::None, 1);         //Default format
    
    gsm.attach(&messageReceive, MODSERIAL::RxAutoDetect);     //Attaches Interrupts
    gsm.autoDetectChar('\n');                                 //Set Detection to Line Feed
    
    gsm.puts("AT\r\n");                       //Check Connection
    messageProcess();                         //Process incoming message
   
    gsm.puts("AT+IFC=0,0");                   //Disable handshake lines
    messageProcess();                         //Process incoming message
    
    gsm.puts("AT+CSMP=17,167,0,0\r\n");       //Set Text Parameters (default values)
    messageProcess();                         //Process incoming message
    
    gsm.puts("AT+CSCA?\r\n");                 //Check Service Center
    messageProcess();                         //Process incoming message

    gsm.puts("AT+CMGF=1\r\n");                //Set format to Text Mode
    
    messageProcess();                         //Process incoming message
    /*
    gsm.printf("AT+CNMI=1,1,0,0,0\r\n");      //Set the new messages indicator
    wait(0.5);
    messageProcess();                         //Process incoming message

    gsm.printf("AT+CSAS\r\n");                //Save the Current Setup, REGLED will light SOLID
    wait(3.0);
    messageProcess();                         //Process incoming message
    //*/
    pc.printf("GSM Setup Done\r\n");
}

void send_SMS(string phoneNumber, string text) {
    pc.printf("Sending: %s\r\n", text);

    gsm.printf("AT+CMGS=\"%s\"\r\n", phoneNumber);
    wait(0.4);
    gsm.printf("%s", text);
    wait(0.4);
    gsm.printf("%c", SUB);
    wait(0.4);
    gsm.printf("\r\n");
    
    if (messageProcess() == 1) {
        pc.printf("SMS sent\r\n");
    } 
    else {
        pc.printf("SMS send failed\r\n");
    }
}

void check_SMS(){
    //string text_id;
    //pc.printf("Checking Messages\r\n");
    while (!gsm.writeable()) {}
    //gsm.puts("AT+CMGL=?\r\n");
    //messageProcess();
    //while (1) {
    gsm.puts("AT+CMGL=\"ALL\"\r\n");          //Check ALL messages
    wait(2);
    messageProcess();
    //gsm.puts("AT+CMGR=1\r\n");
    //messageProcess();
    //gsm.puts("AT+CMGD=1\r\n");
    //messageProcess();
    //}
    //wait(0.4);
    /*gsm.scanf("%s", text_id);
    pc.printf("textID = %s\r\n", text_id);
    text_id = strtok(text_id, ": ");
    //messageProcess();                         //Process incoming message
    gsm.puts("AT+CMGR=%s\r\n", text_id);
    messageProcess();*/
}

void messageReceive(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *sys = q->serial;
    sys->move(messageBufferIncoming, MESSAGE_BUFFER_SIZE);
    if (!strncmp(messageBufferIncoming, "+CMTI", sizeof("+CMTI")-1))
        command_sent = true;
    //messageReceived = true;
    return;
}

int messageProcess() {
    int mpResult = 0;
    wait(0.4);
    if (!strncmp(messageBufferIncoming, "OK", sizeof("OK")-1)) mpResult = 1;
    else if (!strncmp(messageBufferIncoming, "ERROR", sizeof("ERROR")-1)) mpResult = 2;
    else mpResult = 1;
    pc.printf("%s\r\n", messageBufferIncoming);
    gsm.rxBufferFlush();                            //Flush the Buffer
    //messageReceived = false;
    return mpResult;
}
