/* mbd2pmd Board Driver Library
 *
 */

#ifndef MBD2PMD_H
#define MBD2PMD_H

#include "mbed.h"
#include "SDFileSystem.h"
#include "MAX14661.h"

/** mbd2pmd Library, Provides utilities for configuring the mbd2pmd Board
 *
 * Example:
 * @code
 * // Configure board to pass UART signals to peripheral connector.
 *
 * #include "mbd2pmd.h"
 *
 * mbd2pmd m2p;
 *
 * int main() {
 *     m2p.mux.setAB((mbd2pmd::RX | mbd2pmd::PA3), (mbd2pmd::TX | mbd2pmd::PA2));
 * }
 * @endcode
 */
class mbd2pmd
{
public:

    /** Create a mbd2pmd interface
     *
     */
    mbd2pmd();

    ~mbd2pmd();

    /** Initialize the digital pins and PWM
     *
     */
    void init();

    /** mbd2pmd resources SD card, mux, digital IO
    */
    SDFileSystem sd;
    MAX14661 mux;
    DigitalInOut pa1;
    DigitalInOut pa2;
    DigitalInOut pa3;
    DigitalInOut pa4;
    DigitalInOut pb1;
    DigitalInOut pb2;
    DigitalInOut pb3;
    DigitalInOut pb4;

    /** Array of pointers to the DIO pins
    */
    DigitalInOut *pmd[8];

    /** LUT for multiplexer micro connections
    */
    static const int mux_a[17];

    /** LUT for multiplexer PMOD connections
    */
    static const int mux_p[9];

    /** Name the multiplexer connections
    */
    enum MUXsignals {
        PWM1 = MAX14661::SW01,  /**< (1<<0) PWM */
        PWM2 = MAX14661::SW02,  /**< (1<<1) PWM */
        SCL = MAX14661::SW03,  /**< (1<<2) I2C Clock */
        SDA = MAX14661::SW04,  /**< (1<<3) I2C Data */
        TD = MAX14661::SW05,  /**< (1<<4) CAN Transmit */
        RD = MAX14661::SW06,  /**< (1<<5) CAN Receive */
        TX = MAX14661::SW07,  /**< (1<<6) UART Transmit */
        RX = MAX14661::SW08,  /**< (1<<7) UART Receive */
        PA1 = MAX14661::SW09,  /**< (1<<8) Pmd row A pin 1 */
        PB1 = MAX14661::SW10,  /**< (1<<9) Pmd row B pin 1 */
        PA2 = MAX14661::SW11,  /**< (1<<10) Pmd row A pin 2 */
        PB2 = MAX14661::SW12,  /**< (1<<11) Pmd row B pin 2 */
        PA3 = MAX14661::SW13,  /**< (1<<12) Pmd row A pin 3 */
        PB3 = MAX14661::SW14,  /**< (1<<13) Pmd row B pin 3 */
        PA4 = MAX14661::SW15,  /**< (1<<14) Pmd row A pin 4 */
        PB4 = MAX14661::SW16   /**< (1<<15) Pmd row B pin 4 */
    };

};

#endif