/* mbd2pmd Board Driver Library
 *
 */

#include "mbed.h"
#include "mbd2pmd.h"

mbd2pmd::mbd2pmd() :
    mux(p28, p27), sd(p5, p6, p7, p8, "sd"),
    pa1(p14), pa2(p11), pa3(p12), pa4(p13),
    pb1(p24), pb2(p23), pb3(p22), pb4(p21)
{
}

mbd2pmd::~mbd2pmd()
{
}

const int mbd2pmd::mux_a[17] = {RX, TX, RD, PWM1, PB1, PB2, PB3, PB4, TD, PWM2, PA1, PA2, PA3, PA4, SDA, SCL, 0};
const int mbd2pmd::mux_p[9] = {PA1, PA2, PA3, PA4, PB1, PB2, PB3, PB4, 0};

// Initialize Digital IO to inputs with no pullups
void mbd2pmd::init()
{
    pmd[0] = &pa1;
    pmd[1] = &pa2;
    pmd[2] = &pa3;
    pmd[3] = &pa4;
    pmd[4] = &pb1;
    pmd[5] = &pb2;
    pmd[6] = &pb3;
    pmd[7] = &pb4;
    for (int i=0; i < 8; i++) {
        (*pmd[i]).mode(PullNone);
        (*pmd[i]).input();
    }
}
