#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include "muri.h"
#include <stdio.h>
#include <string.h>

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define MURI_MAX_RESP_LENGTH  127
#define I2C_BUFFER_SIZE 31

SDFileSystem sd(p5, p6, p7, p8, "sd"); //
// I2C i2c(p28, p27);
EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char filename[HTTPD_MAX_FNAME_LENGTH+1];
char obuf[MURI_MAX_RESP_LENGTH+1];
char data[I2C_BUFFER_SIZE];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

void get_file(char* uri)
{
    printf("get_file %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        printf("Open directory /sd%s\n", uri);
        *lstchr = 0;
        sprintf(filename, "/sd%s", uri);
        DIR *d = opendir(filename);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                printf("%s\n", p->d_name);
                sprintf(httpHeader,"<li>%s</li>", p->d_name);
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        printf("Directory closed\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        sprintf(filename, "/sd%s", uri);
        fp = fopen(filename, "r");
        if (fp == NULL) {
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            while ((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024) {
                client.send(buffer, rdCnt);
            }
            client.send(buffer, rdCnt);
            fclose(fp);
        }
    }
}

void get_cgi(char* uri)
{
    char *result;
    muri(uri, data, obuf);
    if (!strncmp(obuf, "200 ", 4)) {
        result = obuf +4;
        sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
        client.send(httpHeader,strlen(httpHeader));
        client.send(result,strlen(result));
        printf("result:  %s", result);
    } else {
        sprintf(httpHeader,"HTTP/1.1 ");
        client.send(httpHeader,strlen(httpHeader));
        client.send(obuf,strlen(obuf));
        sprintf(httpHeader,"\r\n");
        client.send(httpHeader,strlen(httpHeader)); 
    }
    
}


int main (void)
{
//    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    
    init_dio(); //initialize pmd digital IO

    while (true) {
        printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        printf("Connection from: %s\r\n", client.get_address());
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    if (!strncmp(uristr, "/muri/", 6)) {
                        get_cgi(uristr+6);
                    } else {
                        get_file(uristr);
                    }
                }
            }
        }

        client.close();
    }
}
