#include "mbed.h"
#include "rtos.h"
#include "muri.h"

I2C i2c(p28, p27);
//PwmOut pwm1(p26);
PwmOut pwm(p25);
DigitalInOut pmd1(p14);
DigitalInOut pmd2(p11);
DigitalInOut pmd3(p12);
DigitalInOut pmd4(p13);
DigitalInOut pmd7(p24);
DigitalInOut pmd8(p23);
DigitalInOut pmd9(p22);
DigitalInOut pmd10(p21);

osTimerDef(poff, pwm_off);
osTimerId off_timer;

void init_dio()
{
    pmd1.mode(PullNone);
    pmd1.mode(OpenDrain);
    pmd1.write(1);
    pmd1.output();
    pmd2.mode(PullNone);
    pmd2.mode(OpenDrain);
    pmd2.write(1);
    pmd2.output();
    pmd3.mode(PullNone);
    pmd3.mode(OpenDrain);
    pmd3.write(1);
    pmd3.output();
    pmd4.mode(PullNone);
    pmd4.mode(OpenDrain);
    pmd4.write(1);
    pmd4.output();
    pmd7.mode(PullNone);
    pmd7.mode(OpenDrain);
    pmd7.write(1);
    pmd7.output();
    pmd8.mode(PullNone);
    pmd8.mode(OpenDrain);
    pmd8.write(1);
    pmd8.output();
    pmd9.mode(PullNone);
    pmd9.mode(OpenDrain);
    pmd9.write(1);
    pmd9.output();
    pmd10.mode(PullNone);
    pmd10.mode(OpenDrain);
    pmd10.write(1);
    pmd10.output();
    off_timer = osTimerCreate(osTimer(poff), osTimerOnce, NULL);
}

void cmd_i2c_write(char* qry, char* data, char* resp)
{
    int addr = 0;
    int dlen = 0;
    int dtmp = 0;
    if (sscanf(qry, "?%2x", &addr) == 1) {
        qry += 3;
        while (sscanf(qry, "&%2x", &dtmp) == 1) {
            data[dlen] = dtmp;
            qry +=3;
            dlen +=1;
        }
    } else {
        dlen = -1;
    }
    if (dlen > 0 ) {
        i2c.write(addr, data, dlen);
        sprintf(resp,"200 %d\r\n", dlen);
    } else {
        if (dlen == 0) {
            sprintf(resp,"204 No data to write: %s\r\n", qry);
        } else {
            sprintf(resp,"400 Invalid parameters: %s\r\n", qry);

        }
    }
}

void cmd_i2c_read(char* qry, char* data, char* resp)
{
    int addr = 0;
    int dlen = 0;
    int dcnt = 0;
    if (sscanf(qry, "?%2x", &addr) == 1) {
        qry += 3;
        if (sscanf(qry, "&%2x", &dlen) == 1) {
            if (i2c.read(addr, data, dlen)!=0) {
                dlen = -1;
                sprintf(resp, "500 I2C read failed\r\n");
            }
        } else {
            sprintf(resp, "400 Invalid data length: %s\r\n", qry);
        }
    } else {
        dlen = -1;
        sprintf(resp, "400 Invalid address: %s\r\n", qry);
    }
    if (dlen > 0) {
        sprintf(resp,"200");
        resp += 3;
        for (dcnt = 0; dcnt < dlen; dcnt++) {
            sprintf(resp," %02x", data[dcnt]);
            resp +=3;
        }
    }
}

void cmd_i2c_addr_read(char* qry, char* data, char* resp)
{
    int addr = 0;
    int radd = 0;
    int dlen = 0;
    int dcnt = 0;
    if (sscanf(qry, "?%2x", &addr) == 1) {
        qry += 3;
        if (sscanf(qry, "&%2x", &radd) == 1) {
            qry += 3;
            if (sscanf(qry, "&%2x", &dlen) == 1) {
                data[0] = radd;
                i2c.write(addr, data, 1, false);
                if (i2c.read(addr, data, dlen)!=0) {
                    dlen = -1;
                    sprintf(resp, "500 I2C read failed\r\n");
                }
            } else {
                sprintf(resp, "400 Invalid data length: %s\r\n", qry);
            }
        } else {
            dlen = -1;
            sprintf(resp, "400 Invalid register address: %s\r\n", qry);
        }
    } else {
        dlen = -1;
        sprintf(resp, "400 Invalid address: %s\r\n", qry);
    }
    if (dlen > 0) {
        sprintf(resp,"200");
        resp += 3;
        for (dcnt = 0; dcnt < dlen; dcnt++) {
            sprintf(resp," %02x", data[dcnt]);
            resp +=3;
        }
    }
}

void cmd_pmd_setio(char* qry, char* data, char* resp)
{
    int pdir = -1;
    int pdata = -1;
    if (sscanf(qry, "?%2x", &pdir) == 1) {
        if (pdir == 0) {
            pmd1.mode(PullNone);
            pmd2.mode(PullNone);
            pmd3.mode(PullNone);
            pmd4.mode(PullNone);
            pmd7.mode(PullNone);
            pmd8.mode(PullNone);
            pmd9.mode(PullNone);
            pmd10.mode(PullNone);
        } else {
            if (sscanf(qry+3, "&%2x", &pdata) == 1) {
                if (pdir & (1 << 0)) {
                    if (pdata & (1 << 0)) pmd1.mode(PullUp);
                    else pmd1.mode(PullDown);
                }  else {
                    pmd1.mode(PullNone);
                }
                if (pdir & (1 << 1)) {
                    if (pdata & (1 << 1)) pmd2.mode(PullUp);
                    else pmd2.mode(PullDown);
                }  else {
                    pmd2.mode(PullNone);
                }
                if (pdir & (1 << 2)) {
                    if (pdata & (1 << 2)) pmd3.mode(PullUp);
                    else pmd3.mode(PullDown);
                }  else {
                    pmd3.mode(PullNone);
                }
                if (pdir & (1 << 3)) {
                    if (pdata & (1 << 3)) pmd4.mode(PullUp);
                    else pmd4.mode(PullDown);
                }  else {
                    pmd4.mode(PullNone);
                }
                if (pdir & (1 << 4)) {
                    if (pdata & (1 << 4)) pmd7.mode(PullUp);
                    else pmd7.mode(PullDown);
                }  else {
                    pmd7.mode(PullNone);
                }
                if (pdir & (1 << 5)) {
                    if (pdata & (1 << 5)) pmd8.mode(PullUp);
                    else pmd8.mode(PullDown);
                }  else {
                    pmd8.mode(PullNone);
                }
                if (pdir & (1 << 6)) {
                    if (pdata & (1 << 6)) pmd9.mode(PullUp);
                    else pmd9.mode(PullDown);
                }  else {
                    pmd9.mode(PullNone);
                }
                if (pdir & (1 << 7)) {
                    if (pdata & (1 << 7)) pmd10.mode(PullUp);
                    else pmd10.mode(PullDown);
                }  else {
                    pmd10.mode(PullNone);
                }
            }
        }

        pdata = 0;
        pdata += (pmd1 << 0);
        pdata += (pmd2 << 1);
        pdata += (pmd3 << 2);
        pdata += (pmd4 << 3);
        pdata += (pmd7 << 4);
        pdata += (pmd8 << 5);
        pdata += (pmd9 << 6);
        pdata += (pmd10 << 7);
        sprintf(resp,"200 %02x", pdata);
    } else {
        sprintf(resp,"400 Invalid parameters: %s\r\n", qry);
    }
}

void cmd_pmd_write(char* qry, char* data, char* resp)
{
    int pdata = -1;
    if (sscanf(qry, "?%2x", &pdata) == 1) {
        pmd1 = pdata & (1 << 0);
        pmd2 = pdata & (1 << 1);
        pmd3 = pdata & (1 << 2);
        pmd4 = pdata & (1 << 3);
        pmd7 = pdata & (1 << 4);
        pmd8 = pdata & (1 << 5);
        pmd9 = pdata & (1 << 6);
        pmd10 = pdata & (1 << 7);
        pdata = 0;
        pdata += (pmd1 << 0);
        pdata += (pmd2 << 1);
        pdata += (pmd3 << 2);
        pdata += (pmd4 << 3);
        pdata += (pmd7 << 4);
        pdata += (pmd8 << 5);
        pdata += (pmd9 << 6);
        pdata += (pmd10 << 7);
        sprintf(resp,"200 %02x", pdata);
    } else {
        sprintf(resp,"400 Invalid parameters: %s\r\n", qry);

    }
}

void cmd_pmd_read(char* qry, char* data, char* resp)
{
    int pdata = 0;
    pdata += (pmd1 << 0);
    pdata += (pmd2 << 1);
    pdata += (pmd3 << 2);
    pdata += (pmd4 << 3);
    pdata += (pmd7 << 4);
    pdata += (pmd8 << 5);
    pdata += (pmd9 << 6);
    pdata += (pmd10 << 7);
    sprintf(resp,"200 %02x", pdata);
}

void pwm_off(void const *arg)
{
//        pwm.period_us(0);
    pwm.pulsewidth_us(0);
}

void cmd_pwm_set(char* qry, char* data, char* resp)
{
    int pwmP = 0;
    int pwmW = 0;
    int pwmD = 0;
    if (sscanf(qry, "?%4x&%4x&%4x", &pwmP, &pwmW, &pwmD) == 3) {
        pwm.period_us(pwmP);
        pwm.pulsewidth_us(pwmW);
        osTimerStart(off_timer, pwmD);
        sprintf(resp,"200 %04x %04x %04x", pwmP, pwmW, pwmD);
    } else {
        sprintf(resp,"400 Invalid parameters: %s\r\n", qry);

    }
}

void muri(char* uri, char* data, char* resp)
{
//    sprintf(resp, "501 %s", uri);
//}
//void get_cgi(char* uri, char* qry)
//{
    char *qry;
    printf("muri uri:  %s\n", uri);
    qry = strstr(uri, "?");
    if (!strncmp(uri, "i2cw?", 5)) { // i2cw [addr] [data] [data] [data] ...
        cmd_i2c_write(qry, data, resp);
    } else if (!strncmp(uri, "i2cr?", 5)) { // i2cr [addr] [count]
        cmd_i2c_read(qry, data, resp);
    } else if (!strncmp(uri, "i2car?", 6)) { // i2car [addr] [radd] [count]
        cmd_i2c_addr_read(qry, data, resp);
    } else if (!strncmp(uri, "pmdio?", 6)) { // pmdio [dir] [data]
        cmd_pmd_setio(qry, data, resp);
    } else if (!strncmp(uri, "pmdw?", 5)) { // pmdw [data]
        cmd_pmd_write(qry, data, resp);
    } else if (!strncmp(uri, "pmdr", 4)) { // pmdr
        cmd_pmd_read(qry, data, resp);
    } else if (!strncmp(uri, "pwmd?", 5)) { // pwmd [period] [width] [duration]
        cmd_pwm_set(qry, data, resp);
    } else {
        sprintf(resp, "501 %s", uri);
    }
    printf("muri resp:  %s\n", resp);
}


