/* MAX14661 Driver Library
 *
 */

#include "MAX14661.h"
#include "mbed.h"

MAX14661::MAX14661(PinName sda, PinName scl, int addr) : _i2c(sda, scl)
{
    _addr = addr;
}

MAX14661::~MAX14661()
{
}

void MAX14661::clearAll()
{
    char data[3];
    data[0] = REG_CMD_A;
    data[1] = CMD_DIS;
    data[2] = CMD_DIS;
    _i2c.write(_addr, data, 3);
}

void MAX14661::setAB(int swA, int swB)
{
    char data[7];
    data[0] = REG_SHDW0;
    data[1] = swA;
    data[2] = swA >> 8;
    data[3] = swB;
    data[4] = swB >> 8;
    data[5] = CMD_COPY;
    data[6] = CMD_COPY;
    _i2c.write(_addr, data, 7);
}

int MAX14661::read()
{
    char data[4];
    data[0] = REG_DIR0;
    _i2c.write(_addr, data, 1, true);
    _i2c.read(_addr, data, 4);
    return ((data[3] << 24) | (data[2] << 16) |(data[1] << 8) | data[0]);
}
