#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include "ARD2PMD.h"
#include "PmodInterface.h"
#include <stdio.h>
#include <string.h>

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127
#define CGI_MAX_RESP_LENGTH  255
#define UART_MAX_CMD_LENGTH  127

Serial uart(USBTX, USBRX);
I2C i2c(D14, D15);
ARD2PMD a2p;
PmodInterface pInt;
SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char obuf[CGI_MAX_RESP_LENGTH+1];
char ibuf[UART_MAX_CMD_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

void get_file(char* uri)
{
    uart.printf("get_file %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        uart.printf("Open directory /sd%s\n", uri);
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s Directory Listing</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                uart.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        uart.printf("Directory closed\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        sprintf(fileName, "/sd%s", uri);
        fp = fopen(fileName, "r");
        if (fp == NULL) {
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            while ((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024) {
                client.send(buffer, rdCnt);
            }
            client.send(buffer, rdCnt);
            fclose(fp);
        }
    }
}

void get_cgi(char* uri)
{
    pInt.call(uri, obuf);
    sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
    client.send(httpHeader,strlen(httpHeader));
    client.send(obuf,strlen(obuf));
    uart.printf("resp:  %s", obuf);
}

void uart_cmd_thread(void const *args)
{
    int i = 0;
    while(true) {
        if (uart.readable()) {
            ibuf[i]=uart.getc();
            if (ibuf[i]!='\r') {
                if (i < 255) {
                    i += 1;
                }
            } else {
                if (i < 255) {
                    ibuf[i]=0;
                    uart.printf("UART CMD:  %s=", ibuf);
                    pInt.call(ibuf, obuf);
                    uart.printf("%s\n", obuf);
                } else {
                    uart.printf("UART Input Command Too Long\n");
                }
                i=0;
            }
        }
    }
}

int main (void)
{
//    Serial Interface Setup;
    uart.baud(115200);
    uart.printf("mbd2pmd Serial Started\n");

//    Mbed to Pmod Initialization;
    a2p.init();

//    Pmod Interface Setup
    pInt.init(&a2p.pmd[0], &i2c, &a2p.mux, a2p.mux_a, a2p.mux_p);

//    Check File System
    DIR *d = opendir("/sd/");
    if (d != NULL) {
        uart.printf("SD Card Present\n");
    } else {
        uart.printf("SD Card Root Directory Not Found\n");
    }

//    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());

//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("mbd2pmd Server Listening\n");

//    Start UART Command Thread
    Thread thread(uart_cmd_thread);
    uart.printf("UART Commands Listening\n");

    while (true) {
        uart.printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        uart.printf("Connection from: %s\r\n", client.get_address());
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    if (!strncmp(uristr, "/pmd/", 5)) {
                        get_cgi(uristr+4);
                    } else {
                        get_file(uristr);
                    }
                }
            }
        }

        client.close();
    }
}
