/* ARD2PMD Board Driver Library
 *
 */

#include "ARD2PMD.h"
#include "mbed.h"

ARD2PMD::ARD2PMD() : 
    pa1(D10), pa2(D11), pa3(D12), pa4(D13),
    pb1(D4), pb2(D5), pb3(D6), pb4(D7),
    mux(D14, D15)
{
}

ARD2PMD::~ARD2PMD()
{
}

const int ARD2PMD::mux_a[17] = {RX, TX, D2, D3, PB1, PB2, PB3, PB4, D8, D9, PA1, PA2, PA3, PA4, SDA, SCL, 0};
const int ARD2PMD::mux_p[9] = {PA1, PA2, PA3, PA4, PB1, PB2, PB3, PB4, 0};

// Initialize Digital IO to inputs with no pullups
void ARD2PMD::init()
{
    pmd[0] = &pa1;
    pmd[1] = &pa2;
    pmd[2] = &pa3;
    pmd[3] = &pa4;
    pmd[4] = &pb1;
    pmd[5] = &pb2;
    pmd[6] = &pb3;
    pmd[7] = &pb4;
    for (int i=0; i < 8; i++) {
        (*pmd[i]).mode(PullNone);
        (*pmd[i]).input();
    }
}
