/* mbed VCODATA Module Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*############################################################################
##############################################################################
*/


#include "mbed.h"
#include <string>
#include <NAVDATA.h>

#ifndef MBED_VCODATA_H
#define MBED_VCODATA_H

/**  VCODATA manage and store navigation data to obtain VCO */


class VCODATA
{
public:
    /* CONSTRUCTOR */
    VCODATA(NAVDATA InitData,int Vel_Max);                  // Argumento: Objeto de la clase NAVDATA que contiene los datos de navegación de un período.

    VCODATA(const VCODATA &VCOOBJ);             // Constructor copia.

    /* DESTRUCTOR */
    ~VCODATA();

    NAVDATA *NAV_DATA;                          // Matriz de datos: Array de objetos NAVDATA. Cada uno corresponde a una velocidad distinta.

    int get_VCO(int* VCC);
    // Return VCO y set VCC[0]=VCO, VCC[1]=VCM

    float performance(int Vi);                  // Devuelve un parametro entre 0 y 1 que mide performance de consumo a velocidad Vi.

    void interpolate();                         // Interpola los valores de consumo para completar la curva.

    void smooth(int n_dots, VCODATA &REFERENCE_MTRX); // Suaviza la curva promediando n puntos. (Pasabajos).

    int store_data (NAVDATA &LastData, int cant_per);    // Almacena LastData. Parámetros: Objeto NAVDATA, cantidad max. de periodos que se concatenan a vel. cte. antes de almacenar.
    // Retorna -1 si hubo error. (i.e. no pudo combinar los datos.

    int vel_max;                                // Velocidad máxima; este parámetro determina tambien la cantidad de objetos NAVDATA que contiene NAV_DATA


private:

    float DeltaV;                               // Rango de velocidad dentro del cual se considera velocidad constante para validar datos.

    int get_next_P(int x_value);                // Busca el indice del siguiente objeto cuyo valor de consumo por milla sea no nulo.

    void interp_x1_x2(int x1,int x2);           // Iterpola entre 2 puntos dados.

    int merge_data(NAVDATA LastVector); // Combina los datos del ultimo objeto ingresado (LastVector.LAST_NAV_DATA) con los del anteriormente ingresado. (this->NAV_DATA[Vmax+1])
    //enum vcodatavars{ timestmp=0, longitude, latitude, consumption, speed, distance, NUM_VCODATAVARS }; Retorna -1 si el período no es válido, sino 0.

    // NAVDATA NAV_DATA[100];      // Matriz de datos: Array de variables tipo NAVDATA(Arrays de datos de navegacion de un período).


};
#endif
