/* NAVDATA Module Library*/

/**  NAVDATA manage and store last navigation data */


#include "mbed.h"
#include <string>
#include <vector>
using namespace std;
#include <math.h>

#ifndef MBED_NAVDATA_H
#define MBED_NAVDATA_H
enum datavars{longitude_f=0, longitude_i, latitude_f, latitude_i, time_f, time_i, distance_p, speed_p, consumption_i, consumption_f, consumption_p, cons_mile_p, cons_hour_p, cons_interpolated, CANT_DATA_VARS }; // Contiene las variables de navegacion de inicio y fin del último período muestreado. (distance_p in nautic miles, speed_p in knots). 0-> real ; 1->interpolated; 2->smoothed; -1-> initial padding.





class NAVDATA {
private:
     
     double Klong, Klat, Ksen;    //Default value is set to obtain distance in nautic miles and consumption in litres.
     
     int ZH; 
     
public:
     int np_concat;               // Cantidad máxima de períodos que combinan en uno solo a velocidad constante antes de almacenar los datos.(ver VCODATA::store_data);
    
    float max_period_time;  //  Maximo tiempo aceptado entre muestras consecutivas para validar los períodos en horas (hh,hhhh). SETEAR en NAVDATA.cpp
     
    double time_NMEA2hours (float timetickNMEA); // Convierte formato de hora NMEA a horas con decimales. (hhmmss,ss  ---> hh,hhhh)
    
    NAVDATA(double Klongitud, double Klatitud, float Ksensor, int ZoneHour, float max_period_time);   // Constantes de latitud, longitud, del sensor, zona horaria y tiempo de periodo maximo.
    
    NAVDATA();  // Sin argumentos
   
   
    void paddata();
    
    /** Rotacion de los datos almacenados con los entrantes. 
     * @return 0 si hubo una rotacion con datos validados, else -1.
     */
     
    int rotate_data(double x, double y, double t, float c, int v_max);  // Longitud, Latitud, Timestamp, Consumption, Velocidad Maxima;
    
    double LAST_NAV_DATA[CANT_DATA_VARS];    // Arrays de datos de navegacion del último período. En caso de agregar variables, modificar enum datavars.

    
};
#endif
 