/* NAVIGATION DATA Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "NAVDATA.h"


/*############################################################################
##############################################################################*/

/* CONSTRUCTOR1: Si no se pasan argumentos se toman los seteados en la declaracion; Latitud/Longitud expresadas en Millas Náuticas, Cte. del sensor en pulsos por Litro y el tiempo maximo de periodo aceptado en segundos*/

    NAVDATA::NAVDATA(double Klongitud=49.38797982997941, double Klatitud=59.99999981628485, float Ksensor=2500, int ZoneHour=-3, float max_period_time=0.002222) : Klong(Klongitud), Klat(Klatitud), Ksen(Ksensor), ZH(ZoneHour) {        
    this->paddata();           
    }
/* CONSTRUCTOR2:Sin argumentos. Necesario para declarar vectores de objetos NAVDATA*/    
    NAVDATA::NAVDATA(){  
    np_concat=1;                      // Cantidad de períodos concatenados.
    Klong= 49.38797982997941;
    Klat=59.99999981628485;
    Ksen=2500;
    ZH=-3;
    max_period_time=0.002222;    // 5 segundos convertidos a horas decimales.
    this->paddata();           
    }
    
    
    
int NAVDATA::rotate_data(double x, double y, double t, float c, int v_max){   // Longitud, Latitud, Timestamp(NMEA), Consumption, Velocidad Maxima;
    
    double time_last=this->time_NMEA2hours(t);                         // EN HORAS
    
    
    this->LAST_NAV_DATA[consumption_i]=this->LAST_NAV_DATA[consumption_f];  // Supongo siempre validos los datos de consumo.
    this->LAST_NAV_DATA[consumption_f]=c/Ksen;
    
    if ( time_last > this->LAST_NAV_DATA[time_f] || this->LAST_NAV_DATA[cons_interpolated]!=0) {     // (Secuencia de timestamps válida?)
        this->LAST_NAV_DATA[longitude_i]=this->LAST_NAV_DATA[longitude_f];
        this->LAST_NAV_DATA[longitude_f]=x;           
        this->LAST_NAV_DATA[latitude_i]=this->LAST_NAV_DATA[latitude_f];
        this->LAST_NAV_DATA[latitude_f]=y;

        this->LAST_NAV_DATA[time_i]=this->LAST_NAV_DATA[time_f];     // EN HORAS
        this->LAST_NAV_DATA[time_f]=time_last; 
        double time_p=this->LAST_NAV_DATA[time_f]-this->LAST_NAV_DATA[time_i];
        this->LAST_NAV_DATA[distance_p]= sqrt(pow(Klong*(this->LAST_NAV_DATA[longitude_f]-this->LAST_NAV_DATA[longitude_i]),2) + pow(Klat*(this->LAST_NAV_DATA[latitude_f]-this->LAST_NAV_DATA[latitude_i]),2)) ; // Distancia recorrida durante este período.
        if (time_p!=0)this->LAST_NAV_DATA[speed_p]=this->LAST_NAV_DATA[distance_p]/(this->LAST_NAV_DATA[time_f]-this->LAST_NAV_DATA[time_i]);    //periodo no nulo?
        else this->LAST_NAV_DATA[speed_p]=-1;
        if(this->LAST_NAV_DATA[speed_p]<0 || this->LAST_NAV_DATA[speed_p]> v_max ) return -1; // Velocidad fuera de rango.          

        this->LAST_NAV_DATA[consumption_p]=this->LAST_NAV_DATA[consumption_f]-this->LAST_NAV_DATA[consumption_i];         // Consumo en litros del período.
        if (this->LAST_NAV_DATA[distance_p] > 0) this->LAST_NAV_DATA[cons_mile_p]=this->LAST_NAV_DATA[consumption_p]/this->LAST_NAV_DATA[distance_p];  //   Consumo en litros por milla nautica.
        else this->LAST_NAV_DATA[cons_mile_p]= -1;                                                                     // Variable no mensurable (-1)
        this->LAST_NAV_DATA[cons_hour_p]=this->LAST_NAV_DATA[consumption_p]/(this->LAST_NAV_DATA[time_f]-this->LAST_NAV_DATA[time_i]);                  // Consumo en litros por hora.

        if (time_p > (this->max_period_time) && this->LAST_NAV_DATA[cons_interpolated]==0) return 1; // tiempo entre muestras reales demasiado grande. Períódo no válido.
        return 0;
    }
    else  {
        this->LAST_NAV_DATA[time_i]=this->LAST_NAV_DATA[time_f];     // EN HORAS - Rotacion de tiempos solamente para actualizar. No se valida período.
        this->LAST_NAV_DATA[time_f]=time_last;                       // Sino, llega a 23:59:59 y no valida nunca más
        return -1;            //(Período no válido. Secuencia de timestamps inválida para datos reales!)
 
    }    
}      

double NAVDATA::time_NMEA2hours(float timetickNMEA){
    double seconds, minutes, hours;
    hours= int(timetickNMEA/10000);                            //Formato NMEA: hhmmss,sss; => int(hh,mmssss)=hh 
    seconds= (timetickNMEA/100 - int(timetickNMEA/100))*100;   // => (hhmmss,sss/100 - int(hhmmss,sss/100))*100 = ss,sss
    minutes= int(timetickNMEA/100 - hours*100);                // => int(hhmm,sssss - hh*100)= mm
    if ((hours+ZH)>=0) return (hours + ZH + minutes/60 + seconds/3600);       // => Hora local,expresado en horas, formato decimal
    else return (hours + 24 + ZH + minutes/60 + seconds/3600);                // => Hora local,expresado en horas, formato decimal
}    

void NAVDATA::paddata(){
    
    this->np_concat=0;                            // Cantidad de periodos concatenados
    this->LAST_NAV_DATA[longitude_f]=-58.5797;    // Longitud y Latitud iniciales y finales correspondiente a Tigre.
    this->LAST_NAV_DATA[longitude_i]=-58.5797;
    this->LAST_NAV_DATA[latitude_f]=-34.4251;
    this->LAST_NAV_DATA[latitude_i]=-34.4251;
    //this->LAST_NAV_DATA[time_f]=-1;               // El dato (timestamp al final del período en cuestion, en horas) se obtendrá luego proveniente del GPS.
    this->LAST_NAV_DATA[time_f]= this->time_NMEA2hours(0);
    //this->LAST_NAV_DATA[time_i]=0;                // Timestamp al inicio del período en horas.
    this->LAST_NAV_DATA[time_i]= this->time_NMEA2hours(0); 
    this->LAST_NAV_DATA[distance_p]=.0f;            // Distancia recorrida durante este período en millas nauticas.
    this->LAST_NAV_DATA[speed_p]=.0f;               // Velocidad media del período en nudos. // CAMBIO: Velocidad inicial cero en vez de -1 201705202152
    this->LAST_NAV_DATA[consumption_i]=.0f;         // Consumo en litros al comienzo del período.
    this->LAST_NAV_DATA[consumption_f]=.0f;         // Consumo en litros al final del período.
    this->LAST_NAV_DATA[consumption_p]=.0f;         // Consumo en litros del período.
    this->LAST_NAV_DATA[cons_mile_p]=.0f;           // Consumo en litros por milla nautica.
    this->LAST_NAV_DATA[cons_hour_p]=.0f;           // Consumo en litros por hora.
    this->LAST_NAV_DATA[cons_interpolated]=-1.0;    // Consumo interpolado?: -1-> initial padding
}    




 