#include "mbed.h"
#include "mbos.h"


#define TASK1_ID                1       // Id for task 1 (idle task is 0)
#define TASK1_PRIO              40      // priority for task 1
#define TASK1_STACK_SZ          32      // stack size for task 1 in words 
#define TASK2_ID                2       // Id for task 2 
#define TASK2_PRIO              30      // priority for task 2
#define TASK2_STACK_SZ          1024      // stack size for task 2 in words 
#define TIMER0_ID               0       // Id for timer 0
#define TIMER0_PERIOD           1000    // Time period in milliseconds
#define TIMER0_EVENT            1       // Event flag (1 << 0)
#define TIMER1_ID               1
#define TIMER1_PERIOD           200
#define TIMER1_EVENT            2


#define N_TASKS                 2 
#define N_TIMERS                2 

void task1(void); //led
void task2(void); //serial

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX);

mbos os(N_TASKS,N_TIMERS);

int main(void)
{
    os.CreateTask(TASK1_ID,TASK1_PRIO,TASK1_STACK_SZ,task1);
    os.CreateTask(TASK2_ID,TASK2_PRIO,TASK2_STACK_SZ,task2);
    os.CreateTimer(TIMER0_ID,TIMER0_EVENT,TASK1_ID);
    os.CreateTimer(TIMER1_ID,TIMER1_EVENT,TASK2_ID);
    
    os.Start();
}

void task1(void)
{
    os.SetTimer(TIMER0_ID,TIMER0_PERIOD,TIMER0_PERIOD);
    while(1){
        os.WaitEvent(TIMER0_EVENT);
        led1 = !led1;
    }
}

void task2(void)
{
    os.SetTimer(TIMER1_ID,TIMER1_PERIOD,TIMER1_PERIOD);
    while(1){
        os.WaitEvent(TIMER1_EVENT);
        led2 = !led2;
        if(pc.readable())
            switch(pc.getc()){
                case '1':
                    pc.printf("Bonjour\n\r");
                    break;
                case '2':
                    pc.printf("Bonsoir\r\n");
                    break;
            }
        
    }

}
