#include "i2c_test.h"

Semaphore sem(0);

I2C i2cMaster(p28, p27);
I2CSlave i2cSlave(p9,p10);

const int spiAddr = 0xA0;
volatile int attente;
volatile int pute;

void testI2C()
{
    attente = 0;
    pute = 1;
    i2cMaster.frequency(100000);
    i2cSlave.frequency(100000);
    i2cSlave.address(0xA0);
    
    Thread tSlave(i2cSlaveTask);
    Thread tMaster(i2cMasterTask);
    //printf("helo1");
    //int i =0;
    //wait(5);
    //do{
    //printf("ha\n\r");
    //}
    //while(attente == 0);
    sem.wait();
    printf("helo2\n\r");
}

void i2cMasterTask(void const* arg)
{
    char test[] = "MASTER";
    char buf[32];
    
    wait(1);
    i2cMaster.write(spiAddr, test, (strlen(test)+1));
    wait(1);
    for(int j = 0; j < 64; j++) buf[j] = 0;     /*effacer le buffer*/
    i2cMaster.read(spiAddr, buf, sizeof(buf));
    if( !strcmp(buf, "MASTER SLAVE") )   printf("TESTE DE PUTE OK\n\r");
    
    sem.release();
    attente = 1;
    pute = 0;
    printf("helo3\n\r");
}


void i2cSlaveTask(void const* arg)
{
    char send[64];
    char rec[64];
    
    strcpy(send,"");
    while(pute) {
        for(int j = 0; j < 64; j++) rec[j] = 0;     /*effacer le buffer*/ 
        switch ( i2cSlave.receive() ) {
            case I2CSlave::ReadAddressed :
                //pc.printf("I2CSlave::ReadAddressed\n\r");
                i2cSlave.write(send, strlen(send) + 1);       
                break;
                
            case I2CSlave::WriteGeneral :
                //pc.printf("I2CSlave::WriteGeneral\n\r");
                i2cSlave.read(rec, sizeof(rec));
                strcpy(send,rec);
                strcat(send," SLAVE");
                break;
                
            case I2CSlave::WriteAddressed :
                //pc.printf("I2CSlave::WriteAddressed\n\r");
                i2cSlave.read(rec, sizeof(rec));
                strcpy(send,rec);
                strcat(send," SLAVE");
                break;
            default :
                break;
        }       
    }
    printf("SLAVE FINI!\n\r");
}