/*
 * for GS2000 (GS2K / GS2100MIP)
 *   SDK BUILDER
 *     Application = Serial to Wi-Fi (Hosted)
 *     Host options for Serial Application = UART Command and SPI Data

Serial2WiFi APP
DataInterfaceReady

AT+BDATA=1
AT+WM=0
AT+NDHCP=1,gsfan
AT+WAUTH=0
AT+WPAPSK=SSID,PASS
AT+WA=SSID
AT+NSUDP=10000

 */
#include "mbed.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);

SPI spi(p5, p6, p7); // mosi(DIN), miso(DOUT), sck(CLK)
DigitalOut cs(p8); // cs(CS)
DigitalInOut reset(p10);
DigitalIn wake(p9); // host wakeup(GPIO28)
Serial ser(p13, p14); // uart

void send () {
    int i;
    char cmd[100];

    // NSUDP cid=0
    sprintf(cmd, "\x1bY%X%s:%d:%04d", 0, "192.168.0.10", 64540, 10);
    for (i = 0; i < strlen(cmd); i ++) {
        cs = 0;
        spi.write(cmd[i]);
        cs = 1;
    }
    for (i = 0; i < 10; i ++) {
        cs = 0;
        spi.write('A' + i);
        cs = 1;
    }
}

int main() {
    Timer t;
    char c;

    pc.baud(115200);
    pc.printf("--- gs spi begin\r\n");

    ser.baud(115200); // uart

    cs = 1;
    wake.mode(PullDown);
    spi.format(8, 1);
    spi.frequency(10000000);
    reset.output();
    reset = 0;
    led2 = 1;

    led1 = 1;
    wait_ms(100);

    reset.input();
    reset.mode(PullUp);
    led2 = 0;

    t.reset();
    t.start();
    for (;;) {
        led3 = wake;
        if (wake == 1) {
            pc.printf("\r\nwake: ");
            for (int i = 0; i < 1000; i ++) {
                cs = 0;
                c = spi.write(0xf5);
                cs = 1;
                if ((c >= 0x20 && c < 0x7f) || c == 0x0d || c == 0x0a) {
                    pc.printf(" %c", c);
                } else
                if (c != 0xf5) {
                    pc.printf(" %02x", c);
                }
                if (wake == 0) break;
            }
            pc.printf(" [EOM]\r\n");
        }

        while (ser.readable()) {
            c = ser.getc();
            if ((c >= 0x20 && c < 0x7f) || c == 0x0d || c == 0x0a) {
                pc.printf("%c", c);
            } else
            if (c != 0xf5) {
                pc.printf(" %02x", c);
            }
        }

        if (pc.readable()) {
            c = pc.getc();
            if (c == '@') {
                send();
            } else {
                pc.putc(c);
                ser.putc(c);
            }
        }
    }
}
