/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

socket.cpp - network sockett class 

Copyright (C) 2011 DIYSandbox LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "dbg.h"
#include "mbed.h"
#include "socket.h"

/**
 * @brief    This Socket function initialize the channel in perticular mode, and set the port and wait for W5100 done it.
 * @return     1 for success else 0.
 */
int GSSocket::socket(SOCKET s, int protocol, int port, int flag)
{
  if ((protocol == IPPROTO::TCP))
  {
    close(s);
    if (port != 0) {
      configSocket(s, protocol, port);
    } 
    else {
      local_port++; // if don't set the source port, set local_port number.
      configSocket(s, protocol, local_port);
    }

    //W5100.execCmdSn(s, Sock_OPEN);
    
    return 1;
  }

  return 0;
}


/**
 * @brief    This function close the socket and parameter is "s" which represent the socket number
 */
void GSSocket::close(SOCKET s)
{
  execSocketCmd(s, CMD_CLOSE_CONN);
}


/**
 * @brief    This function established  the connection for the channel in passive (server) mode. This function waits for the request from the peer.
 * @return    1 for success else 0.
 */
int GSSocket::listen(SOCKET s)
{
  if (readSocketStatus(s) != SOCK_STATUS::INIT)
    return 0;
  execSocketCmd(s, CMD_LISTEN);
  return 1;
}

int GSSocket::recv(SOCKET s, uint8_t *buf, int len)
{
  int ret=0;

  if ( (len > 0) && isDataOnSock(s))
  {
    ret = readData(s, buf, len);
  }

  return ret;
}

void GSSocket::disconnect(SOCKET s)
{
  execSocketCmd(s, CMD_CLOSE_CONN);
}

int GSSocket::send(SOCKET s, const uint8_t *buf, int len)
{
//    int status=0;
    int ret=0;
//    int freesize=0;
    
    if (len > SSIZE) {
        ret = SSIZE; // check size not to exceed MAX size.
    } else { 
        ret = len;
    }
    ret = writeData(s, buf, len);
    
    return ret;
}

/**
 * @brief    This function established  the connection for the channel in Active (client) mode. 
 *         This function waits for the untill the connection is established.
 *         
 * @return    1 for success else 0.
 */
int GSSocket::connect(SOCKET s, Host &host)
{
    if (host.getIp().isNull()) {
        DBG("dns_lookup %s\r\n", host.getName());
        if (!dns_lookup(host)) {
            wait_ms(50);
            if (!dns_lookup(host)) {
                DBG("error dns\r\n");
                return 0;
            }
        }
    }

    if (host.getIp().isNull() || host.getPort() == 0)
        return 0;
    
    // set destination IP
    return connect_socket(host);    
}
