/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

gs.cpp - HAL driver to talk with Gainspan GS1011 WiFi module

Copyright (C) 2011 DIYSandbox LLC

Porting for chipKIT boards Copyright (c) 2012 http://electronics.trev.id.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef    _gs_h_
#define    _gs_h_

#include "mbed.h"
#include "ipaddr.h"
#include "host.h"
#include <stdint.h>

typedef int SOCKET;

class SOCK_STATUS {
public:
  static const uint8_t CLOSED      = 0x00;
  static const uint8_t INIT        = 0x01;
  static const uint8_t LISTEN      = 0x02;
  static const uint8_t ESTABLISHED = 0x03;
  static const uint8_t CLOSE_WAIT  = 0x04;
};

class IPPROTO {
public:
  static const uint8_t TCP  = 6;
};

// command identifiers
// config
#define CMD_DISABLE_ECHO 0
#define CMD_SET_UART_115200 14
// wifi
#define CMD_SET_WPA_PSK  1
#define CMD_SET_SSID     2
#define CMD_DISCONNECT   5
#define CMD_GET_MAC_ADDR 8
//network
#define CMD_DISABLE_DHCP 3
#define CMD_ENABLE_DHCP  4
#define CMD_LISTEN       6
#define CMD_TCP_CONN     7
#define CMD_DNS_LOOKUP   9
#define CMD_CLOSE_CONN   10
#define CMD_NETWORK_SET  11
#define CMD_WIRELESS_MODE 12
#define CMD_ENABLE_DHCPSVR 13

// device operation modes
#define DEV_OP_MODE_COMMAND 0
#define DEV_OP_MODE_DATA    1
#define DEV_OP_MODE_DATA_RX 2

// device wireless connection state
#define DEV_CONN_ST_DISCONNECTED 0
#define DEV_CONN_ST_CONNECTED    1

// connection ID
#define INVALID_CID 255

#define SSIZE 2048 // Max Tx buffer siz

#define MAX_RXBUF_SIZE 32

// wireless connection params
typedef struct _GS_PROFILE {
    char ssid[32];
    char security_key[32];
    IpAddr ip;
    IpAddr subnet;
    IpAddr gateway;
} GS_PROFILE;

typedef struct _SOCK_TABLE {
    int status;
    int protocol;
    int port;
    int cid;
} SOCK_TABLE;

class GSClass {
public:
    GSClass(PinName p_tx, PinName p_rx);
    GSClass(PinName p_tx, PinName p_rx, PinName p_cts, PinName p_rts);
    
    int mode;
    int init(void (*rx_data_handler)(char *data, int len));
    void configure(GS_PROFILE* prof);
    int connect();
    int connected();
    void process();
    int connect_socket(Host &host);
    int dns_lookup(Host &url);
    void send_data(char *data, int len);
    void esc_seq_start();
    void esc_seq_stop();
    uint8_t *get_dev_id();

    void configSocket(SOCKET s, int protocol, int port);
    void execSocketCmd(SOCKET s, int cmd);
    int readSocketStatus(SOCKET s);
    int isDataOnSock(SOCKET s);
    int readData(SOCKET s, uint8_t* buf, int len);
    int writeData(SOCKET s, const uint8_t* buf, int len);
    
//    static const int SSIZE = 2048; // Max Tx buffer siz

    void isr_recv ();
    int getbuf ();
    int bufreadable ();

private:
    char security_key[32];
    char ssid[32];
    IpAddr local_ip;
    IpAddr subnet;
    IpAddr gateway;
    int serv_cid;
    int client_cid;
    int dev_mode;
    IpAddr ip;
    int port;
    int connection_state;
    uint8_t dev_id[6];
    Host dns_url_ip;
    int tx_done;

    SOCK_TABLE sock_table[4];
    int socket_num;
    SOCKET dataOnSock;

    void (*rx_data_handler)(char *data, int len);

    int readline(char *buf, int size);
    int send_cmd(int cmd);
    int parse_resp(int cmd);
    int send_cmd_w_resp(int cmd);
    void parse_cmd(char *buf, int len);
    void parse_data(char *buf, int len);

    void flush();

    Serial _gs;
    bool _rts;
    char _rxbuf[MAX_RXBUF_SIZE];
    volatile int _rxaddr_w, _rxaddr_r;
};

#endif // _gs_h_
