/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

Wirefree.h - interface class to talk with DIYSandbox Arduino devices 

Copyright (C) 2011 DIYSandbox LLC

Porting for chipKIT boards Copyright (c) 2012 http://electronics.trev.id.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef _wirefree_h_
#define _wirefree_h_

#include "socket.h"
#include "WifiClient.h"
#include "WifiServer.h"

#define NORMAL_MODE     0
#define ADHOC_MODE      1
#define AP_MODE         2

typedef struct _WIFI_PROFILE {
    char ssid[32];
    char security_key[32];
    IpAddr ip;
    IpAddr subnet;
    IpAddr gateway;
} WIFI_PROFILE;

class Wirefree : public GSSocket {
public:
  Wirefree(PinName p_tx, PinName p_rx) : GSSocket(p_tx, p_rx) {};
  Wirefree(PinName p_tx, PinName p_rx, PinName p_cts, PinName p_rts) : GSSocket(p_tx, p_rx, p_cts, p_rts) {};

  void begin(WIFI_PROFILE*, void (*rxDataHndlr)(char *data, int len));
  void begin(WIFI_PROFILE*, void (*rxDataHndlr)(char *data, int len), int m);

  void process();
  int connected();
  int socketOpen(Host &host);

  void sendDeviceID();
  void sendResponse(char *data);

  friend class WifiClient;
  friend class WifiServer;
  
private:
  int _server_port[MAX_SOCK_NUM];

};

#endif // _wirefree_h_
