/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

WifiClient.cpp - network client class 

Copyright (C) 2011 DIYSandbox LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "socket.h"
#include "WifiClient.h"

WifiClient::WifiClient(GSSocket &gss) : _gss(gss) {
    _srcport = 10240;
}

WifiClient::WifiClient(GSSocket &gss, int sock) : _sock(sock), _gss(gss) {
    _srcport = 10240;
}

WifiClient::WifiClient(GSSocket &gss, Host &host) : _sock(MAX_SOCK_NUM), _gss(gss) {
    _srcport = 10240;
    _host = host;
}


int WifiClient::connect() {
    if (_sock != MAX_SOCK_NUM)
        return 0;

    for (int i = 0; i < MAX_SOCK_NUM; i++) {
        if (_gss.readSocketStatus(i) == SOCK_STATUS::CLOSED) {
            _sock = i;
            break;
        }
    }
    
    if (_sock == MAX_SOCK_NUM)
        return 0;
    
    _srcport++;
    if (_srcport == 0) _srcport = 10240;
    _gss.socket(_sock, IPPROTO::TCP, _srcport, 0);
    
    if (!_gss.connect(_sock, _host)) {
        _sock = MAX_SOCK_NUM;
        return 0;
    }
    
    while (status() != SOCK_STATUS::ESTABLISHED) {
        wait_ms(1);
        if (status() == SOCK_STATUS::CLOSED) {
            _sock = MAX_SOCK_NUM;
            return 0;
        }
    }

    return 1;
}

int WifiClient::status() {
  if (_sock == MAX_SOCK_NUM) return SOCK_STATUS::CLOSED;
  return _gss.readSocketStatus(_sock);
}

int WifiClient::_putc (int b) {
    if (_sock != MAX_SOCK_NUM)
        _gss.send(_sock, (uint8_t*)&b, 1);
    return 0;
}

int WifiClient::available() {
    if (_sock != MAX_SOCK_NUM) {
        if (_gss.isDataOnSock(_sock)) {
            return 1;
        } else {
            _gss.process();
            return 0;
        }
    }

    return 0;
}

int WifiClient::_getc() {
  char b = 0;

  if (!available() || (_gss.recv(_sock, (uint8_t*)b, 1) != 1))
    return -1;

  return b;
}

int WifiClient::peek() {
  return 0;
}

void WifiClient::flush() {
    while (available())
        _getc();
}

WifiClient::operator bool() {
  return _sock != MAX_SOCK_NUM;
}

int WifiClient::connected() {
  if (_sock == MAX_SOCK_NUM) return 0;

  //uint8_t s = status();
  //return !(s == SOCK_STATUS::LISTEN || s == SOCK_STATUS::CLOSED ||
  //  (s == SOCK_STATUS::CLOSE_WAIT && !available()));

  return (status() == SOCK_STATUS::ESTABLISHED);
}

void WifiClient::stop() {
  if (_sock == MAX_SOCK_NUM)
    return;

  _gss.disconnect(_sock);

  //EthernetClass::_server_port[_sock] = 0;
  _sock = MAX_SOCK_NUM;
}
