/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

socket.h - network socket class 

Copyright (C) 2011 DIYSandbox LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef    _socket_h_
#define    _socket_h_

#include "mbed.h"
#include "gs.h"

#define MAX_SOCK_NUM 4

class GSSocket : public GSClass {
public:
    GSSocket(PinName p_tx, PinName p_rx) : GSClass(p_tx, p_rx) {};
    GSSocket(PinName p_tx, PinName p_rx, PinName p_cts, PinName p_rts) : GSClass(p_tx, p_rx, p_cts, p_rts) {};

    int socket(SOCKET s, int protocol, int port, int flag); // Opens a socket(TCP or UDP or IP_RAW mode)
    void close(SOCKET s); // Close socket
    int listen(SOCKET s);    // Establish TCP connection (Passive connection)
    int recv(SOCKET s, uint8_t *buf, int len);    // Receive data (TCP)
    void disconnect(SOCKET s);
    int send(SOCKET s, const uint8_t *buf, int len); // Send data (TCP)
    int connect(SOCKET s, Host &host); 

private:
    int local_port;

};


#endif // _socket_h_
