#include "mbed.h"
#include "Wirefree.h"

WIFI_PROFILE w_prof = {
    "GSWIFI",
    "PASSWORD",
    IpAddr(0,0,0,0),
    IpAddr(0,0,0,0),
    IpAddr(0,0,0,0)
};
Host server = Host(IpAddr(0,0,0,0), 80, "mbed.org");

Wirefree wireless(p13, p14);
//Wirefree wireless(p13, p14, p12, P0_22); // TX, RX, CTS, RTS

WifiClient client(wireless, server);

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

void parseRxData(char *data, int len)
{
}

int main() {
    char c;

    pc.baud(115200);

    wireless.begin(&w_prof, &parseRxData);

    pc.printf("client connecting...\r\n");
    if (client.connect()) {
        myled = 1;
        pc.printf("connection Success..\r\n");
    
        // Make a HTTP request:
        client.printf("GET / HTTP/1.0\r\n\r\n");
//        client.flush();
    } else {
        pc.printf("connection failed..\r\n");
        return -1;
    }

    for (;;) {
        if (client.available()) {
            c = client.getc();
            if (c >= 0x20 && c < 0x7f) {
                pc.putc(c);
            } else {
                pc.printf(" %02x ", c);
            }
        }
        if (!client.connected()) {
            pc.printf("disconnecting.\r\n");
            client.stop();
            myled = 0;
            break;
        }
    }
}
