/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

Wirefree.cpp - interface class to talk with DIYSandbox Arduino devices 

Copyright (C) 2011 DIYSandbox LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "dbg.h"
#include "Wirefree.h"
#include "gs.h"
#include <string.h>

void Wirefree::begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(char *data, int len))
{
    for (int i = 0; i < MAX_SOCK_NUM; i ++) {
        _server_port[i] = 0;
    }

    DBG("Wirefree.cpp - begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(String data))\r\n");
    DBG("                  call begin(w_prof, rxDataHndlr, NORMAL_MODE);\r\n");
    begin(w_prof, rxDataHndlr, NORMAL_MODE);
    DBG("Wirefree.cpp - begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(String data)) - DONE\r\n");
}

void Wirefree::begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(char *data, int len), int m)
{
    DBG("Wirefree.cpp - begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(String data), uint8_t mode)\r\n");

    mode = m;
    
    // initialize device
    if (!init(rxDataHndlr)) {
        DBG("error: init\r\n");
        return;
    }
    DBG("      initialize device done\r\n");

    // configure params
    configure((GS_PROFILE*)w_prof);
    DBG("      configure params done\r\n");

    // initiate wireless connection
    while (!GSClass::connect());
    DBG("      connect done\r\n");
    
    DBG("Wirefree.cpp - begin(WIFI_PROFILE* w_prof, void (*rxDataHndlr)(String data), uint8_t mode) - DONE\r\n");
}

void Wirefree::process()
{
    GSClass::process();
}

int Wirefree::socketOpen(Host &host)
{
    // get IP address from URL
    if (!dns_lookup(host)) {
        return 0;
    }

    // open socket connection
    if (!connect_socket(host)) {
        return 0;
    }

    return 1;
}

int Wirefree::connected()
{
    return GSClass::connected();
}

void Wirefree::sendDeviceID()
{
    char buf[100] = "ID:";

    strcat(buf, (char*)get_dev_id());
//    send_data(buf, strlen(buf));
}

void Wirefree::sendResponse(char *data)
{
    char buf[100];

    sprintf(buf, "TIME:%s:%d", data, 0);
//    send_data(buf, strlen(buf));
}

