/*
 * Gainspan Wifi library for mbed
 * Modified for mbed, 2012 gsfan.
 *

WifiClient.h - network client class 

Copyright (C) 2011 DIYSandbox LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef _wifi_client_h_
#define _wifi_client_h_

#include "mbed.h"
#include "socket.h"

class WifiClient : public Stream {

public:
  WifiClient(GSSocket &);
  WifiClient(GSSocket &, int);
  WifiClient(GSSocket &, Host &);

  int status();
  int connect();

  //uint8_t connect();
  virtual int _putc (int);
  virtual int available();
  virtual int _getc ();
  virtual int peek();
  virtual void flush();
  operator bool();
  int connected();
  void stop();
  void startDataTx();
  void stopDataTx();
#if 0
  uint8_t operator==(int);
  uint8_t operator!=(int);
#endif

  friend class WifiServer;

private:
  int _srcport;
  int _sock;
  Host _host;
  GSSocket _gss;
};

#endif // _wifi_client_h_
