#include "mbed.h"
#include "GSwifi.h"

#define PORT 10080

#define SECURE GSwifi::GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

void onGsReceive (int cid, int len) {
    int i;
    char buf[100];
    Host host;

    led2 = 1;

    i = gs.recv(cid, buf, sizeof(buf), host);
    gs.send(cid, buf, i, host);
    pc.printf("recv %d\r\n", i);
}

int main () {
    IpAddr ipaddr, netmask, gateway, nameserver;

    led1 = 1;
    pc.baud(115200);

    pc.printf("connect\r\n");
    if (gs.connect(SECURE, SSID, PASS)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);

    pc.printf("listen\r\n");
    gs.listen(PORT, GSwifi::GSPROT_UDP, &onGsReceive);

    for (;;) {
        gs.poll();

        led1 = !led1;
        wait_ms(50);
    }
}
