#include "mbed.h"
#include "GSwifi.h"

#define SECURE GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "passkey"

#define TWITTER "Tweet%20from%20GainSpan%20Wi-Fi"
#define HTTP_HOST "api.supertweet.net" // SuperTweet.net
// #define HTTP_HOST "twitter-basicauth.appspot.com" // TOBASIC!
#define HTTP_URI "/1/statuses/update.xml"
#define HTTP_USER "username"
#define HTTP_PASS "password"

GSwifi gs(p13, p14); // TX, RX (no flow control)
// GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

void onGsReceive (int cid, int len) {
    int i;
    char buf[GS_DATA_SIZE + 1];
    
    led2 = 1;
    i = gs.recv(cid, buf, len);
    buf[i] = 0;
    pc.printf(buf);
}

int main () {
    int r;
    IpAddr ipaddr, netmask, gateway, nameserver;
    Host host;
    char msg[] = "status=" TWITTER;

    led1 = 1;
    pc.baud(115200);
    
    pc.printf("connect\r\n");
    if (gs.connect(SECURE, SSID, PASS, 0)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);
    
    pc.printf("httpPost\r\n");
    host.setName(HTTP_HOST);
    r = gs.httpPost(host, HTTP_URI, msg, HTTP_USER, HTTP_PASS, 0, &onGsReceive);
    if (r >= 0) {
        for (;;) {
            gs.poll();
            if (! gs.isConnected(r)) break;

            wait_ms(50);
            led1 = !led1;
            led2 = 0;
        }
    }

    pc.printf("exit\r\n");
}
