#include "mbed.h"
#include "GSwifi.h"

#define SERVER  "mail.example.com"
#define PORT    587   // or 25
#define TO      "to@example.com"
#define FROM    "from@example.com"
#define SUBJECT "TEST"
#define MESG    "Hello!\r\n"
#define USER    "username"  // SMTP Auth
#define PWD     "password"  // SMTP Auth

#define SECURE GSwifi::GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

int main () {
    IpAddr ipaddr, netmask, gateway, nameserver;
    Host host;
    int r;

    led1 = 1;
    pc.baud(115200);

    pc.printf("connecting...\r\n");
    if (gs.connect(SECURE, SSID, PASS)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);

    led2 = 1;
    pc.printf("sendmail\r\n");
    host.setName(SERVER);
    host.setPort(PORT);
//    r = gs.mail(host, TO, FROM, SUBJECT, MESG);  // no auth
    r = gs.mail(host, TO, FROM, SUBJECT, MESG, USER, PWD);  // SMTP auth
    if (r == 0) {
        pc.printf("sent\r\n");
    } else {
        pc.printf("error\r\n");
    }

    for (;;) {
        gs.poll();

        wait_ms(50);
        led1 = !led1;
        led2 = 0;
    }
}
