#include "mbed.h"
#include "GSwifi.h"

#define SECURITY GSSEC_WPA_PSK
#define SSID "WIFISSID"
#define PASSPHRASE "abcdef1234"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS


// callback
void onGsReceive (int cid, int acid, int len) {
    int i, j;
    char buf[GS_DATA_SIZE];
    
    pc.printf("recv %d %d %d\r\n", cid, acid, len);
    j = gs.recv(cid, buf, len);
    if (j > 0) {
        pc.printf("data: ");
        for (i = 0; i < j; i ++) {
            pc.printf("%02x ", buf[i]);
        }
        pc.printf("\r\n");
    }
}

int main () {
    Host host;

    pc.baud(115200);
    pc.printf("Gainspan\r\n");
    wait(1);

    // connection test
    if (gs.connect(SECURITY, SSID, PASSPHRASE, 0)) {
        pc.printf("Can't connected.\r\n");
        return -1;
    }
/*
    // adhock test
    gs.adhock(GSSEC_OPEN, SSID, PASSPHRASE, IpAddr(192,168,15,5), IpAddr(255,255,255,0));
*/
/*
    // limited ap test
    gs.limitedap(GSSEC_WEP, SSID, PASSPHRASE, IpAddr(192,168,15,5), IpAddr(255,255,255,0));
*/

    // udp server test
    gs.listen(10464, GSPROT_UDP, onGsReceive);

    led1 = 1;
    
/*
    // http get test
    host.setName("mbed.org");
    gs.httpGet(host, "/");
*/
/*
    // http get test2
    host.setName("mbed.org");
    host.setPort(80);
    if (! gs.getHostByName(host)) {
        pc.printf("resolv %d.%d.%d.%d\r\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3]);

        sk = gs.open(host, GSPROT_TCP);
        if (sk >= 0) {
            int i;
            char buf[1500];

            gs.send(sk, "GET /none HTTP/1.0", 18);
            gs.send(sk, "\r\n", 2);
            gs.send(sk, "\r\n", 2);
            wait_ms(5000);

            i = gs.recv(sk, buf, sizeof(buf));
            if (i) {
                buf[i] = 0;
                pc.printf("\r\n");
                pc.printf(buf);
            }

            gs.close(sk);
        }
    }
*/
    
skip:
    // PC Serial <--> GS uart
    led2 = 1;
    for (;;) {
        gs.poll();
        if (pc.readable()) {
            led3 = 1;
            gs.putc(pc.getc());
            led3 = 0;
        }
        if (gs.readable()) {
            led4 = 1;
            pc.putc(gs.getc());
            led4 = 0;
        }
    }
}
