/*
 * RPC over HTTP server for GSwifi
 *
 * RPC access
 *   http://IP address/rpc/DigitalOut/new LED4 myled
 *   http://IP address/rpc/myled/write 1
 *
 *   http://IP address/rpc/AnalogIn/new p20 myadc
 *   http://IP address/rpc/myadc/read
 */

#include "mbed.h"
#include "rpc.h"
#include "GSwifi.h"

#define PORT    80

#define SECURE GSSEC_WPA2_PSK
#define SSID "SSID"
#define PASS "passkey"

// GSwifi gs(p13, p14); // TX, RX (no flow control)
GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS
DigitalOut gs_reset(p9);

LocalFileSystem local("local");

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

void rpc (int cid, GS_httpd *gshttpd) {
    int i;
    char buf[40], outbuf[40];

    buf[0] = '/';    
    gs.urldecode(gshttpd->file, &buf[1], sizeof(buf) - 2);
    rpc(buf, outbuf);  // RPC call
    pc.printf("RPC %d: %s '%s'\r\n", cid, buf, outbuf);

    gs.send(cid, "HTTP/1.1 200 OK\r\n", 17);
    gs.send(cid, "Content-type: text/plain\r\n", 26);
    gs.send(cid, "\r\n", 2);
    gs.send(cid, outbuf, strlen(outbuf));
}

int main () {
    IpAddr ipaddr, netmask, gateway, nameserver;
    Host host;

    gs_reset = 0;
    wait_ms(100);
    gs_reset = 1;
    wait_ms(500);

    led1 = 1;
    pc.baud(115200);

    pc.printf("connecting...\r\n");
    if (gs.connect(SECURE, SSID, PASS)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);

    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<AnalogIn>();

    led2 = 1;
    pc.printf("httpd\r\n");
    gs.httpd(PORT);
    gs.attach_httpd("/rpc/", &rpc);
    gs.attach_httpd("/", "/local/");

    for (;;) {
        gs.poll();

        wait_ms(50);
        led1 = !led1;
        led2 = 0;
    }
}
