/**
 * Gainspan wi-fi module library for mbed
 * Copyright (c) 2012 gsfan
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Gainspan wi-fi module library for mbed
 * GS1011MIC, GS1011MIP, GainSpan WiFi Breakout, etc.
 * module configuration: ATB=115200
 */

#ifndef _GSWIFI_NET_H_
#define _GSWIFI_NET_H_

#include "mbed.h"
#include "host.h"

#define GS_USE_HTTPD  // use http server
//#define GS_USE_WEBSOCKET  // use websocket (need httpd)
#define GS_USE_SMTP  // use smtp client
#define GS_SYSLOG // log for stdout


#ifdef GS_SYSLOG
#define LOG(...) printf("" __VA_ARGS__) 
#else 
#define LOG(...) 
#endif 

// GSwifi_smtp.cpp
#ifdef GS_USE_SMTP

#define SMTP_TIMEOUT 15000

#endif


// GSwifi_httpd.cpp
#ifdef GS_USE_HTTPD

#define HTTPD_TIMEOUT 15000
#define HTTPD_HANDLE 10

#define HTTPD_BUF_SIZE 200
#define HTTPD_URI_SIZE 100

#define HTTPD_KEEPALIVE 10 // request count

enum GSHTTPDMODE {
    GSHTTPDMODE_REQUEST,
    GSHTTPDMODE_HEAD,
    GSHTTPDMODE_SPACE,
    GSHTTPDMODE_BODY,
    GSHTTPDMODE_ERROR,
    GSHTTPDMODE_WEBSOCKET,
    GSHTTPDMODE_WEBSOCKET_MASK,
    GSHTTPDMODE_WEBSOCKET_BODY,
};

struct GS_httpd {
    GSHTTPDMODE mode;
    int type;
    char *buf;  // body
    int len;  // length of buf
    char *uri;
    char *file;
    char *query;
    int length;  // content-length
    int keepalive;
    Host host;
#ifdef GS_USE_WEBSOCKET
    int websocket;
    char *websocket_key;
    int websocket_flg;
    char websocket_mask[4];
    int websocket_payload;
#endif
};

typedef void (*onHttpdCgiFunc)(int cid, GS_httpd *gshttpd);

struct GS_httpd_handler {
    char *uri;
    char *dir;
    onHttpdCgiFunc onHttpCgi;
};

#endif

#endif
