/*
 * HTTP server for GSwifi
 *
 *   create the index.htm for LocalFileSystem.
 *   html access http://IP address/ , http://IP address/test/
 *
 *   CGI access http://IP address/cgi-bin/hoge?hage
 */

#include "mbed.h"
#include "GSwifi.h"

#define PORT    80

#define SECURE GSwifi::GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);


void cgi (int cid, GSwifi::GS_httpd *gshttpd) {
    int i;

    led2 = 1;
    pc.printf("CGI %d: %s ? %s '%s' %d\r\n", cid, gshttpd->file, gshttpd->query, gshttpd->buf, gshttpd->len);

    gs.send(cid, "HTTP/1.1 200 OK\r\n", 17);
    gs.send(cid, "Content-type: text/plain\r\n", 26);
    gs.send(cid, "\r\n", 2);

    gs.send(cid, "REQUEST_METHOD: ", 16);
    if (gshttpd[cid].type == GSwifi::GSPROT_HTTPGET) {
        gs.send(cid, "GET\r\n", 5);
    } else {
        gs.send(cid, "POST\r\n", 6);
    }
    gs.send(cid, "SCRIPT_NAME: ", 13);
    gs.send(cid, gshttpd->file, strlen(gshttpd->file));
    gs.send(cid, "\r\n", 2);
    gs.send(cid, "QUERY_STRING: ", 14);
    gs.send(cid, gshttpd->query, strlen(gshttpd->query));
    gs.send(cid, "\r\n", 2);
    gs.send(cid, "POST_BODY: ", 11);
    gs.send(cid, gshttpd->buf, strlen(gshttpd->buf));
    gs.send(cid, "\r\n", 2);

}

int main () {
    IpAddr ipaddr, netmask, gateway, nameserver;

    led1 = 1;
    pc.baud(115200);

    pc.printf("connecting...\r\n");
    if (gs.connect(SECURE, SSID, PASS)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);

    led2 = 1;
    pc.printf("httpd\r\n");
    gs.httpd(PORT);
    gs.attach_httpd("/test/", "/local/");
    gs.attach_httpd("/cgi-bin/", &cgi);
    gs.attach_httpd("/", "/local/");

    for (;;) {
        gs.poll();

        wait_ms(50);
        led1 = !led1;
        led2 = 0;
    }
}
