/*
 * HTTP(GET/POST) client
 */

#include "mbed.h"
#include "GSwifi.h"

#define HTTP_HOST "www.mbed.org"
#define HTTP_PORT 80
#define HTTP_URI "/"
#define HTTP_BODY "KEY=VALUE&key=value"

#define SECURE GSwifi::GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    gs.disconnect();
    exit(-1);
}

void onGsReceive (int cid, int len) {
    int i;
    char buf[GS_DATA_SIZE + 1];
    
    led2 = 1;
    i = gs.recv(cid, buf, len);
    buf[i] = 0;
    pc.printf(buf);
}

int main () {
    int r;
    IpAddr ipaddr, netmask, gateway, nameserver;
    Host host;

    led1 = 1;
    pc.baud(115200);
    
    pc.printf("connecting...\r\n");
    if (gs.connect(SECURE, SSID, PASS)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);

    pc.printf("httpGet\r\n");
    host.setName(HTTP_HOST);
    host.setPort(HTTP_PORT);
    r = gs.httpGet(host, HTTP_URI, 0, &onGsReceive);
//    r = gs.httpPost(host, HTTP_URI, HTTP_BODY, 0, &onGsReceive);
    if (r >= 0) {
        for (;;) {
            gs.poll();
            if (! gs.isConnected(r)) break;

            wait_ms(50);
            led1 = !led1;
            led2 = 0;
        }
    }

    pc.printf("exit\r\n");
}
