#include "mbed.h"
#include "GSwifi.h"

#define SECURE GSwifi::GSSEC_WPA_PSK
#define SSID "SSID"
#define PASS "passkey"

#define FEED_HOST "api.cosm.com"
#define FEED_ID "000000"
#define API_KEY "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

void onGsReceive (int cid, int len) {
    int i;
    char buf[GS_DATA_SIZE + 1];
    
    led2 = 1;
    i = gs.recv(cid, buf, len);
    buf[i] = 0;
    pc.printf(buf);
}

int cosm (char *data) {
  int i;
  Host host;
  int cid;
  char buf[100];

  host.setName(FEED_HOST);
  host.setPort(80);
  cid = gs.open(host, GSwifi::GSPROT_TCP, &onGsReceive);
  if (cid < 0) return -1;
  
  sprintf(buf, "PUT /v2/feeds/" FEED_ID ".csv HTTP/1.1\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Host: " FEED_HOST "\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Connection: close\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "X-ApiKey: " API_KEY "\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Content-Type: text/csv\r\n");
  gs.send(cid, buf, strlen(buf));
  sprintf(buf, "Content-Length: %d\r\n", strlen(data));
  gs.send(cid, buf, strlen(buf));
  gs.send(cid, "\r\n", 2);
  gs.send(cid, data, strlen(data));

  for (i = 0; i < 10; i ++) {
    if (! gs.isConnected(cid)) break;
    wait(100);
  }
  gs.close(cid);
  return 0;
}

int main () {
    IpAddr ipaddr, netmask, gateway, nameserver;
    char data[] = "1,123\r\n2,345\r\n";

    led1 = 1;
    pc.baud(115200);
    
    pc.printf("connect\r\n");
    if (gs.connect(SECURE, SSID, PASS, 0)) {
        return -1;
    }
    gs.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("ip %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);
    
    pc.printf("Cosm\r\n");
    cosm(data);

    pc.printf("exit\r\n");
}
