#include "mbed.h"
#include "GSwifi.h"

#define PORT 10464

#define SECURE GSwifi::GSSEC_WEP
#define SSID "SSID"
#define PASS "1234567890" // 10 or 26 hexadecimal digits

GSwifi gs(p13, p14, p20); // TX, RX, Reset (no flow control)
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // TX, RX, CTS, RTS, Reset, Alarm

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2);

void onGsReceive (int cid, int len) {
    int i, j;
    char buf[100];
    Host host;

    led2 = 1;

    i = gs.recv(cid, buf, sizeof(buf), host);
    for (j = 0; j < i; j ++) {
        pc.printf(" %02x", buf[j]);
    }   
    pc.printf("\r\n");
}

int main () {

    led1 = 1;
    pc.baud(115200);

    pc.printf("limitedap\r\n");
    if (gs.limitedap(SECURE, SSID, PASS, IpAddr(192,168,15,5), IpAddr(255,255,255,0))) {
        return -1;
    }

    pc.printf("listen\r\n");
    gs.listen(PORT, GSwifi::GSPROT_UDP, &onGsReceive);

    for (;;) {
        gs.poll();

        wait_ms(50);
        led1 = !led1;
        led2 = 0;
    }
}
