#include "mbed.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

#define WS_SERVER "sockets.mbed.org"
#define WS_URI    "/ws/username/rw"

#ifndef CFG_ENABLE_WEBSOCKET
#error Please enable "#define CFG_ENABLE_WEBSOCKET" in "GSwifi_conf.h"
#endif

Serial pc(USBTX, USBRX);

int main() {
    GSwifiInterface gs(p13, p14, p12, P0_22, p20, NC);
//    GSwifiInterface gs(p13, p14, NC, NC, p20, NC);
    pc.baud(115200);
    printf("WebSocket Client...\r\n");
    gs.init(); //Use DHCP
    if (gs.connect(SEC, SSID, PASS)) exit(-1); // join the network
    printf("IP Address is %s\r\n", gs.getIPAddress());

    int cid = gs.wsOpen (WS_SERVER, 80, WS_URI);
    if (cid < 0) {
        printf("error: wsOpen\r\n");
        return -1;
    }

    printf("WebSocket ready\r\n");
    for (;;) {
        gs.poll();

        if (pc.readable()) {
            char c;
            char buf[2];
            c = pc.getc();
            if (c == 0x1b) break; // ESC
            pc.printf("send: %c\r\n", c);
            buf[0] = c;
            gs.wsSend(cid, buf, 1, "MASK");
        }

        if (gs.readable(cid)) {
           int i, n;
           char buf[40];
           n = gs.recv(cid, buf, sizeof(buf));
           printf("recv: ");
           for (i = 0; i < n; i ++) {
               printf(" %02x", buf[i]);
           }
           printf("\r\n");
        }

        if (!gs.isConnected(cid)) {
            break;
        }
    }

    gs.dissociate();
    return 0;
}
