#include "mbed.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

#define ECHO_SERVER_PORT   10000

int main() {
    GSwifiInterface gs(p13, p14, p12, P0_22, p20, NC);
    printf("UDP Echo Server...\n");
    gs.init(); //Use DHCP
    if (gs.connect(SEC, SSID, PASS)) return -1; // join the network
    printf("IP Address is %s\n", gs.getIPAddress());
    
    UDPSocket server;
    server.bind(ECHO_SERVER_PORT);
    
    Endpoint client;
    char buffer[256];
    while (true) {
        printf("\nWait for packet...\n");
        int n = server.receiveFrom(client, buffer, sizeof(buffer));
        
        printf("Received packet from: %s\n", client.get_address());
        server.sendTo(client, buffer, n);
    }
}
