#include "mbed.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

#define ECHO_SERVER_ADDRESS "192.168.1.101"
#define ECHO_SERVER_PORT   10000

int main () {
    GSwifiInterface gs(p13, p14, p12, P0_22, p20, NC);
    printf("UDP Echo Client...\n");
    gs.init(); //Use DHCP
    if (gs.connect(SEC, SSID, PASS)) return -1; // join the network
    printf("IP Address is %s\n", gs.getIPAddress());
    
    UDPSocket sock;
    sock.init();
    
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    char out_buffer[] = "Hello World\n";
    sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
    
    char in_buffer[256];
    int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));
    
    in_buffer[n] = '\0';
    printf("%s\n", in_buffer);
    
    sock.close();
    
    gs.disconnect();
    while(1) {}
}
