#include "mbed.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

#define ECHO_SERVER_PORT   10000

int main () {
    GSwifiInterface gs(p13, p14, p12, P0_22, p20, NC);
    printf("TCP Echo Server...\n");
    gs.init(); //Use DHCP
    if (gs.connect(SEC, SSID, PASS)) return -1; // join the network
    printf("IP Address is %s\n", gs.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}