#include "mbed.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSID"
#define PASS "PASSPHRASE"

#define ECHO_SERVER_ADDRESS "192.168.1.101"
#define ECHO_SERVER_PORT   10000

int main() {
    GSwifiInterface gs(p13, p14, p12, P0_22, p20, NC);
    printf("TCP Echo Client...\n");
    gs.init(); //Use DHCP
    if (gs.connect(SEC, SSID, PASS)) return -1; // join the network
    printf("IP Address is %s\n", gs.getIPAddress());
    
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    
    char hello[] = "Hello World\n";
    socket.send_all(hello, sizeof(hello) - 1);
    
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    printf("%s", buf);
    
    socket.close();
    gs.disconnect();
    
    while(true) {}
}