#include "mbed.h"
#include "GSwifiInterface.h"

Serial pc(USBTX, USBRX);

/* GSwifi object where:
*     - p13 and p14 are for the serial communication
*     - p12 and P0_22 are for the serial handshake (optional)
*     - p9 is for the reset pin
*     - "SSID" is the ssid of the network
*     - "PHRASE" is the password
*     - SEC_WEP is the security
*/
//GSwifiInterface gs(p13, p14, p12, P0_22, p9, "SSID", "PHRASE", GSwifi::SEC_WPA_PSK);
GSwifiInterface gs(p13, p14, NC, NC, p9, "SSID", "PHRASE", GSwifi::SEC_WPA_PSK);
// TX, RX, CTS, RTS, RESET

int main() {
    pc.baud(115200);
    gs.init(); // use DHCP
    if (gs.connect() == false) return -1; // join the network
    printf("IP Address is %s\n\r", gs.getIPAddress());
    gs.disconnect();
}
