/*
 * Please modify "GSwifi_conf.h"
 * ----------
 * #define CFG_ENABLE_RTOS
 * #define CFG_ENABLE_HTTPD
 * #define CFG_ENABLE_WEBSOCKET
 * //#define CFG_ENABLE_SMTP
 * ----------
 */

#include "mbed.h"
#include "SDFileSystem.h"
#include "GSwifiInterface.h"

#define SEC  GSwifi::SEC_WPA_PSK
#define SSID "SSPD"
#define PASS "PASSPHRASE"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
LocalFileSystem local("local");
SDFileSystem sd(p5, p6, p7, p8, "sd");

GSwifiInterface *gs;

void cgi (int cid) {
    int i;
    char buf[100];

    led2 = 1;
    i = gs->recv(cid, buf, sizeof(buf));
    if (i < 0) return;
    buf[i] = 0;
    pc.printf("CGI %d: %s ? %s '%s' %d\r\n", cid, gs->httpdGetFilename(cid), gs->httpdGetQuerystring(cid), buf, i);

    gs->send(cid, "HTTP/1.1 200 OK\r\n", 17);
    gs->send(cid, "Content-type: text/plain\r\n", 26);
    gs->send(cid, "\r\n", 2);

    gs->send(cid, "BODY: ", 6);
    gs->send(cid, buf, strlen(buf));
    gs->send(cid, "\r\n", 2);
    gs->close(cid);
}

void ws_server (int cid) {
    int i;
    char buf[100];

    led2 = 1;
    i = gs->recv(cid, buf, sizeof(buf));
    if (i < 0) return;
    buf[i] = 0;
    pc.printf("WS %d: '%s' %d\r\n", cid, buf, i);

    gs->wsSend(cid, buf, i);
}

int main () {

    pc.baud(115200);
//    pc.baud(921600);
    printf("HTTP Server...\r\n");
    led1 = 1;
    gs = new GSwifiInterface(p13, p14, p12, P0_22, p21, NC, 9600);
    gs->init(); //Use DHCP
    if (gs->connect(SEC, SSID, PASS)) return -1; // join the network
    printf("IP Address is %s\n", gs->getIPAddress());

    printf("ready\r\n");
    gs->httpd();
    gs->httpdAttach("/cgi-bin/", &cgi);
    gs->httpdAttach("/ws/", &ws_server, 1);
    gs->httpdAttach("/test/", "/sd/www/");
    gs->httpdAttach("/", "/local/");

    for (;;) {
        if (pc.readable()) {
            if (pc.getc() == 'q') break;
        }

        wait_ms(50);
        led1 = !led1;
        led2 = 0;
    }
    gs->dissociate();
    return 0;
}
