/**
 * Gainspan wi-fi module library for mbed
 * Copyright (c) 2012 gsfan
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Gainspan wi-fi module library for mbed
 * GS1011MIC, GS1011MIP, GainSpan WiFi Breakout, etc.
 * module configuration: ATB=115200
 */

#ifndef _GSWIFI_NET_H_
#define _GSWIFI_NET_H_

#include "mbed.h"
#include "host.h"

#define GS_USE_HTTPD  // comment out if not use httpd
#define GS_USE_SMTP  // comment out if not use smtp
#define GS_SYSLOG


#ifdef GS_SYSLOG
#define LOG(...) printf("" __VA_ARGS__) 
#else 
#define LOG(...) 
#endif 

// GSwifi_smtp.cpp
#ifdef GS_USE_SMTP

#define SMTP_TIMEOUT 15000

#endif


// GSwifi_httpd.cpp
#ifdef GS_USE_HTTPD

#define HTTPD_TIMEOUT 15000
#define HTTPD_HANDLE 10

#define HTTPD_BUF_SIZE 200
#define HTTPD_URI_SIZE 50

#define HTTPD_KEEPALIVE 10 // request count

struct GS_httpd {
    int mode;
    int type;
    char *buf;  // body
    int len;  // length of buf
    char *uri;
    char *file;
    char *query;
    int length;  // content-length
    int keepalive;
    Host host;
};

typedef void (*onHttpdCgiFunc)(int cid, GS_httpd *gshttpd);

struct GS_httpd_handler {
    char *uri;
    char *dir;
    onHttpdCgiFunc onHttpCgi;
};

#endif

#endif
