//---------------------------------------------------------------
//  Demo program of Button class and ButtonGroup class
//
//  2016/02/22, Copyright (c) 2016 MIKAMI, Naoki
//---------------------------------------------------------------

#include "button_group.hpp"
#define T_MAIUSCOLA = 1
#define T_MINUSCOLA = 2
using namespace Mikami;

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;

void aggiornatastiera(void);

uint8_t tastiera = 0;   // 0 = Maiuscolo  1 = Minuscolo 
uint8_t ssid_psw_press = 0;   // 0=NULLA  1=SSID 2=PASSWORD 3=PRESS 

const int Y0 = 5;
    const int X1 = 10;
    const int Y1 = 220;
    const uint32_t BACK_COLOR = 0xFF006A6C;             // teal green
    //const uint32_t INACTIVE = BACK_COLOR & 0xE0FFFFFF;  // color for inactive button
    const int LETTER_BUTTONS = 45;
    const string MAIUSCOLO[LETTER_BUTTONS] = {"Q", "W", "E", "R","T", "Y", "U", "I","O", "P", "A", "S","D", "F", "G", "H", "J", "K", "L", "Z", "X", "C", "V", "B", "N", "M", "1", "2", "3", "4","5", "6", "7", "8","9", "0", "#", "@", "*" ,"!", "_","$","&","%","DEL"};
    const string MINUSCOLO[LETTER_BUTTONS] = {"q", "w", "e", "r","t", "y", "u", "i","o", "p", "a", "s","d", "f", "g", "h", "j", "k", "l", "z", "x", "c", "v", "b", "n", "m", "1", "2", "3", "4","5", "6", "7", "8","9", "0", "#", "@", "*", "!","_","$","&","%", "DEL"};
    char ARRAY_MINUSCOLO[] = {'q', 'w', 'e', 'r','t', 'y', 'u', 'i','o', 'p', 'a', 's','d', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', '1', '2', '3', '4','5', '6', '7', '8','9','0','#','@','*','!','_','$','&','%',};
    char ARRAY_MAIUSCOLO[] = {'Q', 'W', 'E', 'R','T', 'Y', 'U', 'I','O', 'P', 'A', 'S','D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '1', '2', '3', '4','5', '6', '7', '8','9','0','#','@','*','!','_','$','&','%',};
    char SSID[] = {NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL};
    char PASSWORD [] = {NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL};
    uint8_t text[30];
    float gasPressureInBar = 3.0;
    
int main()
{
   
    lcd_.Clear(BACK_COLOR);     
    ButtonGroup bGroup(lcd_, ts_, 10, Y0, 47, 29,
                      LCD_COLOR_BLUE, LCD_COLOR_DARKBLUE, LETTER_BUTTONS, MAIUSCOLO, 5, 5, 9,Font16);
                           
    const string STR_SW[4] = {"SSID", "PSW" , "BAR", "OK"};
    ButtonGroup sw(lcd_, ts_, 130, 220, 55, 40,
                   LCD_COLOR_GRAY, LCD_COLOR_DARKBLUE, 4, STR_SW, 5, 0, 4, Font16);
    
    const string PIU_MENO[2] = {"+", "-"};
    ButtonGroup piu_meno(lcd_, ts_, 369, 220, 50, 40,
                   LCD_COLOR_BLUE, LCD_COLOR_DARKBLUE, 2, PIU_MENO, 5, 0, 2, Font16);
    
    const string STR_MA_MIN[2] = {"A", "a"};
    ButtonGroup ma_min(lcd_, ts_, 10, 220, 55, 40,
                   LCD_COLOR_GRAY, LCD_COLOR_BLACK, 2, STR_MA_MIN, 5, 0, 2, Font16);
   
    int num;
    int num1;
  
        
    while (true)
    {
        //dOut = 1;
        bool touched = bGroup.GetTouchedNumber(num, LCD_COLOR_DARKBLUE);
        bool touched1 = piu_meno.GetTouchedNumber(num1, LCD_COLOR_DARKBLUE);
       // bool touched2 = ma_min.GetTouchedNumber(num2, LCD_COLOR_BLACK);
        //dOut = 0;
        //char tastino;
        //tastino = '\0';
        
        if (touched1 && ssid_psw_press == 3 && num1 == 0) {
            gasPressureInBar = gasPressureInBar + 0.1;
            sprintf((char*)text, "%3.2f Bar", gasPressureInBar);
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                                ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&text, LEFT_MODE);
            lcd_.SetBackColor(oldcolor_back);
            wait(0.3);
            piu_meno.Redraw(num1);
            
        }
        
        if (touched1 && ssid_psw_press == 3 && num1 == 1) {
            
            gasPressureInBar = gasPressureInBar - 0.1;
            sprintf((char*)text, "%3.2f Bar", gasPressureInBar);
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                                ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&text, LEFT_MODE);
            lcd_.SetBackColor(oldcolor_back);
            wait(0.3);
            piu_meno.Redraw(num1);
            }
            
            if (ma_min.Touched(0, LCD_COLOR_BLACK)) {
                 tastiera = 0;
            }   
            
            if (ma_min.Touched(1, LCD_COLOR_BLACK)) {
                 tastiera = 1;
            }
            
        
        if (touched)
        {
            
            char tastino;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_WHITE);
            
            
            if (tastiera == 0 && num<=(LETTER_BUTTONS-2)){
                tastino = ARRAY_MAIUSCOLO[num];
            }  
            if (tastiera == 1 && num<=(LETTER_BUTTONS-2)){
                tastino = ARRAY_MINUSCOLO[num];
            }  
                       
            int n = 0;
            
            if(num <= (LETTER_BUTTONS-2)) {
            
            // -------------------
            if(ssid_psw_press == 1) { 
            while((SSID[n] !=NULL)) {
              n++;
            } 
              if (n<27) {          
              SSID[n] = tastino;
              }
            }
            // -------------------
            if(ssid_psw_press == 2) { 
            while((PASSWORD[n] !=NULL)) {
              n++;
            }            
              if (n<27) { 
              PASSWORD[n] = tastino;
              }
            }
            } else {

            // delete char ---------
            
            if(ssid_psw_press == 1) { 
            while((SSID[n] !=NULL)) {
              n++;
            } 
              if (n != 0) {          
                  SSID[n-1] = NULL;
              }
            }
           
            // -------------------
            if(ssid_psw_press == 2) { 
            while((PASSWORD[n] != NULL)) {
              n++;
            }            
              if (n != 0 ) { 
                 PASSWORD[n-1] = NULL;
              }
            }     
            
              // ---------------------
            }    
            
            // -------------------
            
            
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            if (ssid_psw_press == 1 || ssid_psw_press == 1) {  
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                              ", LEFT_MODE);
            }
            lcd_.SetTextColor(oldcolor_text);
            if (ssid_psw_press == 1) {
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&SSID, LEFT_MODE);
            //printf("%s\n",SSID);
            //lcd_.DisplayStringAt(X1+300, Y1-27, (uint8_t *)&tastino, LEFT_MODE);
            }
            if (ssid_psw_press == 2) {
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                               ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            lcd_.DisplayStringAt(X1, Y1-25, (uint8_t *)"PASSWORD:", LEFT_MODE);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&PASSWORD, LEFT_MODE);
            lcd_.SetBackColor(oldcolor_back);


            }
            if (ssid_psw_press == 3) {
            sprintf((char*)text, "%3.2f Bar", gasPressureInBar);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&text, LEFT_MODE);
            }
            lcd_.SetBackColor(oldcolor_back);
            wait(0.3);
            bGroup.Redraw(num);
            
        }
          
        //if (sw.Touched(0, LCD_COLOR_GREEN)) {
            //tastiera = 0;
            //aggiornatastiera();
        //}    
        
        //if (sw.Touched(1, LCD_COLOR_GREEN)) {
            //tastiera = 1;
            //aggiornatastiera();
        //}    
        if (sw.Touched(0, LCD_COLOR_GREEN)) {
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                                ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            lcd_.DisplayStringAt(X1, Y1-25, (uint8_t *)"SSID    :", LEFT_MODE);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&SSID, LEFT_MODE);
            ssid_psw_press = 1;
            lcd_.SetBackColor(oldcolor_back);
        }
        if (sw.Touched(1, LCD_COLOR_GREEN)) {
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                               ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            //printf("%s\n",PASSWORD);
            lcd_.DisplayStringAt(X1, Y1-25, (uint8_t *)"PASSWORD:", LEFT_MODE);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&PASSWORD, LEFT_MODE);
            ssid_psw_press = 2;
            lcd_.SetBackColor(oldcolor_back);
        }
        if (sw.Touched(2, LCD_COLOR_GREEN)) {
            int oldcolor_text = lcd_.GetTextColor();
            int oldcolor_back = lcd_.GetBackColor();
            lcd_.SetTextColor(BACK_COLOR);
            lcd_.SetBackColor(LCD_COLOR_GRAY);
            lcd_.DisplayStringAt(X1+110, Y1-25, (uint8_t *)"                                ", LEFT_MODE);
            lcd_.SetTextColor(oldcolor_text);
            lcd_.DisplayStringAt(X1, Y1-25, (uint8_t *)"PRESSURE:", LEFT_MODE);
            sprintf((char*)text, "%3.2f Bar", gasPressureInBar);
            //lcd_.DisplayStringAt(300, 200, (uint8_t *)&text, LEFT_MODE);
            lcd_.DisplayStringAt(X1+120, Y1-25, (uint8_t *)&text, LEFT_MODE);
            ssid_psw_press = 3;
            lcd_.SetBackColor(oldcolor_back);
        }
        
        if (sw.Touched(3, LCD_COLOR_GREEN)) {
            // function Exit
        }
       
        
        wait(0.01f);
        
}
}           
