#include "AverageFilter.h"
#include "mbed.h"

AverageFilter::AverageFilter(int size){
    this->speedVector.reserve(size);
    this->index = 0;
    this->size = size;
    for (int i=0; i<size; i++)
        this->speedVector[i]=0;
}

void AverageFilter::insert(int val){
    this->speedVector[index++%this->size] = val;
}

float AverageFilter::compute(){
    float speed = 0;
    for (int i=0; i<size; i++)
        speed += speedVector[i];
    speed /= this->size;
    return speed;
}
