#include "mbed.h"
#include "EthernetInterface.h"

#define WEB_SERVER_PORT   80

int main (void) 
{
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    const char ip_addr[] = "192.168.0.222"; 
    const char mask_addr[] = "255.255.255.0"; 
    const char gateway_addr[] = "192.168.0.1";
    
    EthernetInterface eth;
    //eth.init(mac_addr); //Use DHCP
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(WEB_SERVER_PORT);
    server.listen();

    while (true) 
    {
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        
        while (true) {
            
            wait(0.5);
            int n = client.receive_all(buffer, sizeof(buffer));
            if (n <= 0) break;
            //buffer[n] = '\0';
            
            printf("rev_dat : %s\r\n", buffer);
         
        }
        
        client.close();
    }
    
}
 