/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <cstdlib>
#include <ctime>
#include <math.h>
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"

BLE        ble;
DigitalOut led(P0_19,1);
DigitalOut myled(P0_8);
DigitalOut neo(P0_6,1);
DigitalOut pin4(P0_4);
DigitalOut pin5(P0_5);
DigitalOut pin15(P0_15);
DigitalOut pin29(P0_29);

static const unsigned NUM_ROBOTS = 4;

uint16_t customServiceUUID  = 0xA000;
uint16_t readwriteCharUUID  = 0xA001;

uint8_t info[NUM_ROBOTS]= {0,0,0,1};

ReadWriteArrayGattCharacteristic<uint8_t, NUM_ROBOTS> readwriteChar(readwriteCharUUID, info);

GattCharacteristic *characteristics[] = {&readwriteChar};

GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

DiscoveredCharacteristic characteristics_discovered;

uint8_t rgb=1;
uint8_t info_t[NUM_ROBOTS]= {0,};

void RGB_Show(uint8_t r, uint8_t g, uint8_t b)
{
    uint8_t rgb[3] = {g, r, b};
    uint8_t *p = rgb;
    uint8_t *end = p + 3;
    while (p < end) {
        uint8_t pix = *p++;
        for (uint8_t mask = 0x80; mask; mask >>= 1) {
            if (pix & mask) {
                // T1H 760ns
                NRF_GPIO->OUTSET = (1UL << 8);
                NRF_GPIO->OUTSET = (1UL << 8);
                NRF_GPIO->OUTSET = (1UL << 8);
                // T1L 660ns
                NRF_GPIO->OUTCLR = (1UL << 8);
            } else {
                // T0H 380ns
                NRF_GPIO->OUTSET = (1UL << 8);
                // T0L 840ns
                NRF_GPIO->OUTCLR = (1UL << 8);
                NRF_GPIO->OUTCLR = (1UL << 8);
                NRF_GPIO->OUTCLR = (1UL << 8);
                NRF_GPIO->OUTCLR = (1UL << 8);
            }
        }
    }
    NRF_GPIO->OUTCLR = (1UL << 8);
    wait_us(100);
}

void periodicCallback(void)
{
    led=!led;
}

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    printf("adv peerAddr[%02x %02x %02x %02x %02x %02x]\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0]);
    ble.gap().stopAdvertising();
}

void onDataWrittenCallback(const GattWriteCallbackParams *params)
{
    ble.gap().disconnect(params->connHandle,Gap::REMOTE_USER_TERMINATED_CONNECTION);
}

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    printf("Current info : ");
    for(int i=0; i<NUM_ROBOTS; i++) {
        printf("%u \t",info[i]);
    }
    printf("\r\n");
    
    wait(10);
    
    if(rgb==7) {
        rgb = 1;
    }else {
        rgb++;
    }
    
    info[0] = rgb%2;
    info[1] = (rgb>>1)%2;
    info[2] = (rgb>>2)%2;
    info[3] = 1;
    
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::RABOT_REDBEAR_BLE_NANO, (uint8_t *)info, sizeof(info));
    ble.gap().setAdvertisingInterval(59);
    ble.gap().startAdvertising();
}

int main(void)
{   
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    info[0] = rgb%2;
    info[1] = (rgb>>1)%2;
    info[2] = (rgb>>2)%2;
    
    printf("Source node \r\n");
    printf("Current info : ");
    for(int i=0; i<NUM_ROBOTS; i++) {
        printf("%u \t",info[i]);
    }
    printf("\r\n");
    
    ble.init();
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::RABOT_REDBEAR_BLE_NANO, (uint8_t *)info, sizeof(info));
    ble.gap().setAdvertisingInterval(59);
    ble.gap().startAdvertising();
    
    ble.addService(customService);
 
    while (true) {
        ble.waitForEvent();
        RGB_Show(info[0],info[1],info[2]);
    }
}
